/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption;

public class DescribeOrderableDBInstanceOptionsIterable
implements SdkIterable<DescribeOrderableDbInstanceOptionsResponse> {
    private final DocDbClient client;
    private final DescribeOrderableDbInstanceOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrderableDBInstanceOptionsIterable(DocDbClient client, DescribeOrderableDbInstanceOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrderableDbInstanceOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableDbInstanceOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        Function<DescribeOrderableDbInstanceOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableDBInstanceOptions() != null) {
                return response.orderableDBInstanceOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeOrderableDBInstanceOptionsIterable resume(DescribeOrderableDbInstanceOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableDBInstanceOptionsIterable(this.client, (DescribeOrderableDbInstanceOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableDBInstanceOptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeOrderableDbInstanceOptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeOrderableDbInstanceOptionsResponseFetcher
    implements SyncPageFetcher<DescribeOrderableDbInstanceOptionsResponse> {
        private DescribeOrderableDbInstanceOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableDbInstanceOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeOrderableDbInstanceOptionsResponse nextPage(DescribeOrderableDbInstanceOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableDBInstanceOptionsIterable.this.client.describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsIterable.this.firstRequest);
            }
            return DescribeOrderableDBInstanceOptionsIterable.this.client.describeOrderableDBInstanceOptions((DescribeOrderableDbInstanceOptionsRequest)((Object)DescribeOrderableDBInstanceOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

