/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.Filter;
import software.amazon.awssdk.services.docdb.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterSnapshotsRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, DescribeDbClusterSnapshotsRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::dbClusterIdentifier)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterSnapshotIdentifier").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::dbClusterSnapshotIdentifier)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::dbClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::snapshotType)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::filters)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::maxRecords)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::marker)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeShared").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::includeShared)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::includeShared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeShared").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePublic").getter(DescribeDbClusterSnapshotsRequest.getter(DescribeDbClusterSnapshotsRequest::includePublic)).setter(DescribeDbClusterSnapshotsRequest.setter(Builder::includePublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePublic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_TYPE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, INCLUDE_SHARED_FIELD, INCLUDE_PUBLIC_FIELD));
    private final String dbClusterIdentifier;
    private final String dbClusterSnapshotIdentifier;
    private final String snapshotType;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean includeShared;
    private final Boolean includePublic;

    private DescribeDbClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.includeShared = builder.includeShared;
        this.includePublic = builder.includePublic;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean includeShared() {
        return this.includeShared;
    }

    public final Boolean includePublic() {
        return this.includePublic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeShared());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePublic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterSnapshotsRequest)) {
            return false;
        }
        DescribeDbClusterSnapshotsRequest other = (DescribeDbClusterSnapshotsRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.snapshotType(), other.snapshotType()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.includeShared(), other.includeShared()) && Objects.equals(this.includePublic(), other.includePublic());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClusterSnapshotsRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("SnapshotType", (Object)this.snapshotType()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("IncludeShared", (Object)this.includeShared()).add("IncludePublic", (Object)this.includePublic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "IncludeShared": {
                return Optional.ofNullable(clazz.cast(this.includeShared()));
            }
            case "IncludePublic": {
                return Optional.ofNullable(clazz.cast(this.includePublic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeDbClusterSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String dbClusterSnapshotIdentifier;
        private String snapshotType;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;
        private Boolean includeShared;
        private Boolean includePublic;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterSnapshotsRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.snapshotType(model.snapshotType);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.includeShared(model.includeShared);
            this.includePublic(model.includePublic);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        @Transient
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        @Transient
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getIncludeShared() {
            return this.includeShared;
        }

        public final void setIncludeShared(Boolean includeShared) {
            this.includeShared = includeShared;
        }

        @Override
        @Transient
        public final Builder includeShared(Boolean includeShared) {
            this.includeShared = includeShared;
            return this;
        }

        public final Boolean getIncludePublic() {
            return this.includePublic;
        }

        public final void setIncludePublic(Boolean includePublic) {
            this.includePublic = includePublic;
        }

        @Override
        @Transient
        public final Builder includePublic(Boolean includePublic) {
            this.includePublic = includePublic;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbClusterSnapshotsRequest build() {
            return new DescribeDbClusterSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterSnapshotsRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder snapshotType(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder includeShared(Boolean var1);

        public Builder includePublic(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

