/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateIdentifier").getter(Certificate.getter(Certificate::certificateIdentifier)).setter(Certificate.setter(Builder::certificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build()}).build();
    private static final SdkField<String> CERTIFICATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateType").getter(Certificate.getter(Certificate::certificateType)).setter(Certificate.setter(Builder::certificateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateType").build()}).build();
    private static final SdkField<String> THUMBPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Thumbprint").getter(Certificate.getter(Certificate::thumbprint)).setter(Certificate.setter(Builder::thumbprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbprint").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFrom").getter(Certificate.getter(Certificate::validFrom)).setter(Certificate.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").build()}).build();
    private static final SdkField<Instant> VALID_TILL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidTill").getter(Certificate.getter(Certificate::validTill)).setter(Certificate.setter(Builder::validTill)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTill").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(Certificate.getter(Certificate::certificateArn)).setter(Certificate.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD, CERTIFICATE_TYPE_FIELD, THUMBPRINT_FIELD, VALID_FROM_FIELD, VALID_TILL_FIELD, CERTIFICATE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateIdentifier;
    private final String certificateType;
    private final String thumbprint;
    private final Instant validFrom;
    private final Instant validTill;
    private final String certificateArn;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateType = builder.certificateType;
        this.thumbprint = builder.thumbprint;
        this.validFrom = builder.validFrom;
        this.validTill = builder.validTill;
        this.certificateArn = builder.certificateArn;
    }

    public final String certificateIdentifier() {
        return this.certificateIdentifier;
    }

    public final String certificateType() {
        return this.certificateType;
    }

    public final String thumbprint() {
        return this.thumbprint;
    }

    public final Instant validFrom() {
        return this.validFrom;
    }

    public final Instant validTill() {
        return this.validTill;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateType());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTill());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.certificateIdentifier(), other.certificateIdentifier()) && Objects.equals(this.certificateType(), other.certificateType()) && Objects.equals(this.thumbprint(), other.thumbprint()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validTill(), other.validTill()) && Objects.equals(this.certificateArn(), other.certificateArn());
    }

    public final String toString() {
        return ToString.builder((String)"Certificate").add("CertificateIdentifier", (Object)this.certificateIdentifier()).add("CertificateType", (Object)this.certificateType()).add("Thumbprint", (Object)this.thumbprint()).add("ValidFrom", (Object)this.validFrom()).add("ValidTill", (Object)this.validTill()).add("CertificateArn", (Object)this.certificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateIdentifier()));
            }
            case "CertificateType": {
                return Optional.ofNullable(clazz.cast(this.certificateType()));
            }
            case "Thumbprint": {
                return Optional.ofNullable(clazz.cast(this.thumbprint()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidTill": {
                return Optional.ofNullable(clazz.cast(this.validTill()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateIdentifier;
        private String certificateType;
        private String thumbprint;
        private Instant validFrom;
        private Instant validTill;
        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.certificateIdentifier(model.certificateIdentifier);
            this.certificateType(model.certificateType);
            this.thumbprint(model.thumbprint);
            this.validFrom(model.validFrom);
            this.validTill(model.validTill);
            this.certificateArn(model.certificateArn);
        }

        public final String getCertificateIdentifier() {
            return this.certificateIdentifier;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        @Override
        @Transient
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final String getCertificateType() {
            return this.certificateType;
        }

        public final void setCertificateType(String certificateType) {
            this.certificateType = certificateType;
        }

        @Override
        @Transient
        public final Builder certificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public final String getThumbprint() {
            return this.thumbprint;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        @Override
        @Transient
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        @Transient
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidTill() {
            return this.validTill;
        }

        public final void setValidTill(Instant validTill) {
            this.validTill = validTill;
        }

        @Override
        @Transient
        public final Builder validTill(Instant validTill) {
            this.validTill = validTill;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public Certificate build() {
            return new Certificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificate> {
        public Builder certificateIdentifier(String var1);

        public Builder certificateType(String var1);

        public Builder thumbprint(String var1);

        public Builder validFrom(Instant var1);

        public Builder validTill(Instant var1);

        public Builder certificateArn(String var1);
    }
}

