/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.Certificate;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;

public class DescribeCertificatesIterable
implements SdkIterable<DescribeCertificatesResponse> {
    private final DocDbClient client;
    private final DescribeCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCertificatesIterable(DocDbClient client, DescribeCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCertificatesResponseFetcher();
    }

    public Iterator<DescribeCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Certificate> certificates() {
        Function<DescribeCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCertificatesResponseFetcher
    implements SyncPageFetcher<DescribeCertificatesResponse> {
        private DescribeCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCertificatesResponse nextPage(DescribeCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCertificatesIterable.this.client.describeCertificates(DescribeCertificatesIterable.this.firstRequest);
            }
            return DescribeCertificatesIterable.this.client.describeCertificates((DescribeCertificatesRequest)((Object)DescribeCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

