/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBClusterSnapshot;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;

public class DescribeDBClusterSnapshotsIterable
implements SdkIterable<DescribeDbClusterSnapshotsResponse> {
    private final DocDbClient client;
    private final DescribeDbClusterSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterSnapshotsIterable(DocDbClient client, DescribeDbClusterSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClusterSnapshotsResponseFetcher();
    }

    public Iterator<DescribeDbClusterSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterSnapshot> dbClusterSnapshots() {
        Function<DescribeDbClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterSnapshots() != null) {
                return response.dbClusterSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterSnapshotsResponse> {
        private DescribeDbClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterSnapshotsResponse nextPage(DescribeDbClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterSnapshotsIterable.this.client.describeDBClusterSnapshots(DescribeDBClusterSnapshotsIterable.this.firstRequest);
            }
            return DescribeDBClusterSnapshotsIterable.this.client.describeDBClusterSnapshots((DescribeDbClusterSnapshotsRequest)((Object)DescribeDBClusterSnapshotsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

