/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdb.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.docdb.model.CertificateNotFoundException;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdb.model.DocDbException;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.docdb.model.InvalidRestoreException;
import software.amazon.awssdk.services.docdb.model.InvalidSubnetException;
import software.amazon.awssdk.services.docdb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.docdb.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.docdb.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StartDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StartDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StopDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StopDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.docdb.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsPublisher;
import software.amazon.awssdk.services.docdb.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDocDbAsyncClient
implements DocDbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDocDbAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDocDbAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addTagsToResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsToResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)applyPendingMaintenanceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificatesResponse> describeCertificates(DescribeCertificatesRequest describeCertificatesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificates");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCertificatesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificates").withMarshaller((Marshaller)new DescribeCertificatesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeCertificatesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeCertificatesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameterGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterParameterGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterParametersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshotAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClustersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClustersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClustersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBClustersPublisher describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) {
        return new DescribeDBClustersPublisher(this, this.applyPaginatorUserAgent(describeDbClustersRequest));
    }

    @Override
    public CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBEngineVersions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbEngineVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbEngineVersionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbEngineVersionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        return new DescribeDBEngineVersionsPublisher(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    @Override
    public CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBInstances");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbInstancesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return new DescribeDBInstancesPublisher(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    @Override
    public CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBSubnetGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbSubnetGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        return new DescribeDBSubnetGroupsPublisher(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventCategoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventCategoriesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableDBInstanceOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        return new DescribeOrderableDBInstanceOptionsPublisher(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    @Override
    public CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describePendingMaintenanceActionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)failoverDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = failoverDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, failoverDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterSnapshotAttribute");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)rebootDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rebootDbInstanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, rebootDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeTagsFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsFromResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resetDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterFromSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterToPointInTime");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDbClusterResponse> startDBCluster(StartDbClusterRequest startDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)startDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, startDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDbClusterResponse> stopDBCluster(StopDbClusterRequest stopDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)stopDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopDbClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDocDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DocDbException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends DocDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.60").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DocDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

