/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.CreateRule;
import software.amazon.awssdk.services.dlm.model.RetainRule;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.services.dlm.model.TagsToAddListCopier;
import software.amazon.awssdk.services.dlm.model.VariableTagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Schedule.getter(Schedule::name)).setter(Schedule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Schedule.getter(Schedule::copyTags)).setter(Schedule.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<List<Tag>> TAGS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Schedule.getter(Schedule::tagsToAdd)).setter(Schedule.setter(Builder::tagsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> VARIABLE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Schedule.getter(Schedule::variableTags)).setter(Schedule.setter(Builder::variableTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariableTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreateRule> CREATE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Schedule.getter(Schedule::createRule)).setter(Schedule.setter(Builder::createRule)).constructor(CreateRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateRule").build()}).build();
    private static final SdkField<RetainRule> RETAIN_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Schedule.getter(Schedule::retainRule)).setter(Schedule.setter(Builder::retainRule)).constructor(RetainRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COPY_TAGS_FIELD, TAGS_TO_ADD_FIELD, VARIABLE_TAGS_FIELD, CREATE_RULE_FIELD, RETAIN_RULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean copyTags;
    private final List<Tag> tagsToAdd;
    private final List<Tag> variableTags;
    private final CreateRule createRule;
    private final RetainRule retainRule;

    private Schedule(BuilderImpl builder) {
        this.name = builder.name;
        this.copyTags = builder.copyTags;
        this.tagsToAdd = builder.tagsToAdd;
        this.variableTags = builder.variableTags;
        this.createRule = builder.createRule;
        this.retainRule = builder.retainRule;
    }

    public String name() {
        return this.name;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public List<Tag> tagsToAdd() {
        return this.tagsToAdd;
    }

    public List<Tag> variableTags() {
        return this.variableTags;
    }

    public CreateRule createRule() {
        return this.createRule;
    }

    public RetainRule retainRule() {
        return this.retainRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.createRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainRule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.tagsToAdd(), other.tagsToAdd()) && Objects.equals(this.variableTags(), other.variableTags()) && Objects.equals(this.createRule(), other.createRule()) && Objects.equals(this.retainRule(), other.retainRule());
    }

    public String toString() {
        return ToString.builder((String)"Schedule").add("Name", (Object)this.name()).add("CopyTags", (Object)this.copyTags()).add("TagsToAdd", this.tagsToAdd()).add("VariableTags", this.variableTags()).add("CreateRule", (Object)this.createRule()).add("RetainRule", (Object)this.retainRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "TagsToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagsToAdd()));
            }
            case "VariableTags": {
                return Optional.ofNullable(clazz.cast(this.variableTags()));
            }
            case "CreateRule": {
                return Optional.ofNullable(clazz.cast(this.createRule()));
            }
            case "RetainRule": {
                return Optional.ofNullable(clazz.cast(this.retainRule()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean copyTags;
        private List<Tag> tagsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> variableTags = DefaultSdkAutoConstructList.getInstance();
        private CreateRule createRule;
        private RetainRule retainRule;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.name(model.name);
            this.copyTags(model.copyTags);
            this.tagsToAdd(model.tagsToAdd);
            this.variableTags(model.variableTags);
            this.createRule(model.createRule);
            this.retainRule(model.retainRule);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final Collection<Tag.Builder> getTagsToAdd() {
            return this.tagsToAdd != null ? (Collection)this.tagsToAdd.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Tag ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Consumer<Tag.Builder> ... tagsToAdd) {
            this.tagsToAdd(Stream.of(tagsToAdd).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagsToAddListCopier.copyFromBuilder(tagsToAdd);
        }

        public final Collection<Tag.Builder> getVariableTags() {
            return this.variableTags != null ? (Collection)this.variableTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variableTags(Collection<Tag> variableTags) {
            this.variableTags = VariableTagsListCopier.copy(variableTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Tag ... variableTags) {
            this.variableTags(Arrays.asList(variableTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableTags(Consumer<Tag.Builder> ... variableTags) {
            this.variableTags(Stream.of(variableTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariableTags(Collection<Tag.BuilderImpl> variableTags) {
            this.variableTags = VariableTagsListCopier.copyFromBuilder(variableTags);
        }

        public final CreateRule.Builder getCreateRule() {
            return this.createRule != null ? this.createRule.toBuilder() : null;
        }

        @Override
        public final Builder createRule(CreateRule createRule) {
            this.createRule = createRule;
            return this;
        }

        public final void setCreateRule(CreateRule.BuilderImpl createRule) {
            this.createRule = createRule != null ? createRule.build() : null;
        }

        public final RetainRule.Builder getRetainRule() {
            return this.retainRule != null ? this.retainRule.toBuilder() : null;
        }

        @Override
        public final Builder retainRule(RetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final void setRetainRule(RetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder name(String var1);

        public Builder copyTags(Boolean var1);

        public Builder tagsToAdd(Collection<Tag> var1);

        public Builder tagsToAdd(Tag ... var1);

        public Builder tagsToAdd(Consumer<Tag.Builder> ... var1);

        public Builder variableTags(Collection<Tag> var1);

        public Builder variableTags(Tag ... var1);

        public Builder variableTags(Consumer<Tag.Builder> ... var1);

        public Builder createRule(CreateRule var1);

        default public Builder createRule(Consumer<CreateRule.Builder> createRule) {
            return this.createRule((CreateRule)((CreateRule.Builder)CreateRule.builder().applyMutation(createRule)).build());
        }

        public Builder retainRule(RetainRule var1);

        default public Builder retainRule(Consumer<RetainRule.Builder> retainRule) {
            return this.retainRule((RetainRule)((RetainRule.Builder)RetainRule.builder().applyMutation(retainRule)).build());
        }
    }
}

