/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.DlmException;
import software.amazon.awssdk.services.dlm.model.PolicyIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceNotFoundException
extends DlmException
implements ToCopyableBuilder<Builder, ResourceNotFoundException> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(ResourceNotFoundException.getter(ResourceNotFoundException::code)).setter(ResourceNotFoundException.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceNotFoundException.getter(ResourceNotFoundException::resourceType)).setter(ResourceNotFoundException.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIds").getter(ResourceNotFoundException.getter(ResourceNotFoundException::resourceIds)).setter(ResourceNotFoundException.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceNotFoundException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String resourceType;
    private final List<String> resourceIds;

    private ResourceNotFoundException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String code() {
        return this.code;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Code", CODE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceIds", RESOURCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceNotFoundException, T> g) {
        return obj -> g.apply((ResourceNotFoundException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmException.BuilderImpl
    implements Builder {
        private String code;
        private String resourceType;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceNotFoundException model) {
            super(model);
            this.code(model.code);
            this.resourceType(model.resourceType);
            this.resourceIds(model.resourceIds);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = PolicyIdListCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = PolicyIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ResourceNotFoundException build() {
            return new ResourceNotFoundException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceNotFoundException>,
    DlmException.Builder {
        public Builder code(String var1);

        public Builder resourceType(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

