/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventSourceValues {
    MANAGED_CWE("MANAGED_CWE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventSourceValues> VALUE_MAP;
    private final String value;

    private EventSourceValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventSourceValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventSourceValues> knownValues() {
        EnumSet<EventSourceValues> knownValues = EnumSet.allOf(EventSourceValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventSourceValues.class, EventSourceValues::toString);
    }
}

