/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrossRegionCopyDeprecateRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrossRegionCopyDeprecateRule> {
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(CrossRegionCopyDeprecateRule.getter(CrossRegionCopyDeprecateRule::interval)).setter(CrossRegionCopyDeprecateRule.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<String> INTERVAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntervalUnit").getter(CrossRegionCopyDeprecateRule.getter(CrossRegionCopyDeprecateRule::intervalUnitAsString)).setter(CrossRegionCopyDeprecateRule.setter(Builder::intervalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD, INTERVAL_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer interval;
    private final String intervalUnit;

    private CrossRegionCopyDeprecateRule(BuilderImpl builder) {
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final RetentionIntervalUnitValues intervalUnit() {
        return RetentionIntervalUnitValues.fromValue(this.intervalUnit);
    }

    public final String intervalUnitAsString() {
        return this.intervalUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyDeprecateRule)) {
            return false;
        }
        CrossRegionCopyDeprecateRule other = (CrossRegionCopyDeprecateRule)obj;
        return Objects.equals(this.interval(), other.interval()) && Objects.equals(this.intervalUnitAsString(), other.intervalUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CrossRegionCopyDeprecateRule").add("Interval", (Object)this.interval()).add("IntervalUnit", (Object)this.intervalUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "IntervalUnit": {
                return Optional.ofNullable(clazz.cast(this.intervalUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyDeprecateRule, T> g) {
        return obj -> g.apply((CrossRegionCopyDeprecateRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer interval;
        private String intervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyDeprecateRule model) {
            this.interval(model.interval);
            this.intervalUnit(model.intervalUnit);
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        @Transient
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final String getIntervalUnit() {
            return this.intervalUnit;
        }

        public final void setIntervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
        }

        @Override
        @Transient
        public final Builder intervalUnit(String intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder intervalUnit(RetentionIntervalUnitValues intervalUnit) {
            this.intervalUnit(intervalUnit == null ? null : intervalUnit.toString());
            return this;
        }

        public CrossRegionCopyDeprecateRule build() {
            return new CrossRegionCopyDeprecateRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrossRegionCopyDeprecateRule> {
        public Builder interval(Integer var1);

        public Builder intervalUnit(String var1);

        public Builder intervalUnit(RetentionIntervalUnitValues var1);
    }
}

