/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues;
import software.amazon.awssdk.services.dlm.model.ShareTargetAccountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareRule> {
    private static final SdkField<List<String>> TARGET_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetAccounts").getter(ShareRule.getter(ShareRule::targetAccounts)).setter(ShareRule.setter(Builder::targetAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> UNSHARE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnshareInterval").getter(ShareRule.getter(ShareRule::unshareInterval)).setter(ShareRule.setter(Builder::unshareInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnshareInterval").build()}).build();
    private static final SdkField<String> UNSHARE_INTERVAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnshareIntervalUnit").getter(ShareRule.getter(ShareRule::unshareIntervalUnitAsString)).setter(ShareRule.setter(Builder::unshareIntervalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnshareIntervalUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ACCOUNTS_FIELD, UNSHARE_INTERVAL_FIELD, UNSHARE_INTERVAL_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> targetAccounts;
    private final Integer unshareInterval;
    private final String unshareIntervalUnit;

    private ShareRule(BuilderImpl builder) {
        this.targetAccounts = builder.targetAccounts;
        this.unshareInterval = builder.unshareInterval;
        this.unshareIntervalUnit = builder.unshareIntervalUnit;
    }

    public final boolean hasTargetAccounts() {
        return this.targetAccounts != null && !(this.targetAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> targetAccounts() {
        return this.targetAccounts;
    }

    public final Integer unshareInterval() {
        return this.unshareInterval;
    }

    public final RetentionIntervalUnitValues unshareIntervalUnit() {
        return RetentionIntervalUnitValues.fromValue(this.unshareIntervalUnit);
    }

    public final String unshareIntervalUnitAsString() {
        return this.unshareIntervalUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetAccounts() ? this.targetAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unshareInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.unshareIntervalUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareRule)) {
            return false;
        }
        ShareRule other = (ShareRule)obj;
        return this.hasTargetAccounts() == other.hasTargetAccounts() && Objects.equals(this.targetAccounts(), other.targetAccounts()) && Objects.equals(this.unshareInterval(), other.unshareInterval()) && Objects.equals(this.unshareIntervalUnitAsString(), other.unshareIntervalUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ShareRule").add("TargetAccounts", this.hasTargetAccounts() ? this.targetAccounts() : null).add("UnshareInterval", (Object)this.unshareInterval()).add("UnshareIntervalUnit", (Object)this.unshareIntervalUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetAccounts": {
                return Optional.ofNullable(clazz.cast(this.targetAccounts()));
            }
            case "UnshareInterval": {
                return Optional.ofNullable(clazz.cast(this.unshareInterval()));
            }
            case "UnshareIntervalUnit": {
                return Optional.ofNullable(clazz.cast(this.unshareIntervalUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareRule, T> g) {
        return obj -> g.apply((ShareRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> targetAccounts = DefaultSdkAutoConstructList.getInstance();
        private Integer unshareInterval;
        private String unshareIntervalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareRule model) {
            this.targetAccounts(model.targetAccounts);
            this.unshareInterval(model.unshareInterval);
            this.unshareIntervalUnit(model.unshareIntervalUnit);
        }

        public final Collection<String> getTargetAccounts() {
            if (this.targetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetAccounts;
        }

        public final void setTargetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ShareTargetAccountListCopier.copy(targetAccounts);
        }

        @Override
        @Transient
        public final Builder targetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ShareTargetAccountListCopier.copy(targetAccounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetAccounts(String ... targetAccounts) {
            this.targetAccounts(Arrays.asList(targetAccounts));
            return this;
        }

        public final Integer getUnshareInterval() {
            return this.unshareInterval;
        }

        public final void setUnshareInterval(Integer unshareInterval) {
            this.unshareInterval = unshareInterval;
        }

        @Override
        @Transient
        public final Builder unshareInterval(Integer unshareInterval) {
            this.unshareInterval = unshareInterval;
            return this;
        }

        public final String getUnshareIntervalUnit() {
            return this.unshareIntervalUnit;
        }

        public final void setUnshareIntervalUnit(String unshareIntervalUnit) {
            this.unshareIntervalUnit = unshareIntervalUnit;
        }

        @Override
        @Transient
        public final Builder unshareIntervalUnit(String unshareIntervalUnit) {
            this.unshareIntervalUnit = unshareIntervalUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder unshareIntervalUnit(RetentionIntervalUnitValues unshareIntervalUnit) {
            this.unshareIntervalUnit(unshareIntervalUnit == null ? null : unshareIntervalUnit.toString());
            return this;
        }

        public ShareRule build() {
            return new ShareRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareRule> {
        public Builder targetAccounts(Collection<String> var1);

        public Builder targetAccounts(String ... var1);

        public Builder unshareInterval(Integer var1);

        public Builder unshareIntervalUnit(String var1);

        public Builder unshareIntervalUnit(RetentionIntervalUnitValues var1);
    }
}

