/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.EventParameters;
import software.amazon.awssdk.services.dlm.model.EventSourceValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EventSource.getter(EventSource::typeAsString)).setter(EventSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<EventParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(EventSource.getter(EventSource::parameters)).setter(EventSource.setter(Builder::parameters)).constructor(EventParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final EventParameters parameters;

    private EventSource(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    public final EventSourceValues type() {
        return EventSourceValues.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final EventParameters parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSource)) {
            return false;
        }
        EventSource other = (EventSource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"EventSource").add("Type", (Object)this.typeAsString()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSource, T> g) {
        return obj -> g.apply((EventSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private EventParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSource model) {
            this.type(model.type);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EventSourceValues type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final EventParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(EventParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(EventParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public EventSource build() {
            return new EventSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSource> {
        public Builder type(String var1);

        public Builder type(EventSourceValues var1);

        public Builder parameters(EventParameters var1);

        default public Builder parameters(Consumer<EventParameters.Builder> parameters) {
            return this.parameters((EventParameters)((EventParameters.Builder)EventParameters.builder().applyMutation(parameters)).build());
        }
    }
}

