/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Action.getter(Action::name)).setter(Action.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<CrossRegionCopyAction>> CROSS_REGION_COPY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossRegionCopy").getter(Action.getter(Action::crossRegionCopy)).setter(Action.setter(Builder::crossRegionCopy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionCopyAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CROSS_REGION_COPY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<CrossRegionCopyAction> crossRegionCopy;

    private Action(BuilderImpl builder) {
        this.name = builder.name;
        this.crossRegionCopy = builder.crossRegionCopy;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasCrossRegionCopy() {
        return this.crossRegionCopy != null && !(this.crossRegionCopy instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionCopyAction> crossRegionCopy() {
        return this.crossRegionCopy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionCopy() ? this.crossRegionCopy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.name(), other.name()) && this.hasCrossRegionCopy() == other.hasCrossRegionCopy() && Objects.equals(this.crossRegionCopy(), other.crossRegionCopy());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("Name", (Object)this.name()).add("CrossRegionCopy", this.hasCrossRegionCopy() ? this.crossRegionCopy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CrossRegionCopy": {
                return Optional.ofNullable(clazz.cast(this.crossRegionCopy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<CrossRegionCopyAction> crossRegionCopy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.name(model.name);
            this.crossRegionCopy(model.crossRegionCopy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<CrossRegionCopyAction.Builder> getCrossRegionCopy() {
            if (this.crossRegionCopy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossRegionCopy != null ? (Collection)this.crossRegionCopy.stream().map(CrossRegionCopyAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crossRegionCopy(Collection<CrossRegionCopyAction> crossRegionCopy) {
            this.crossRegionCopy = CrossRegionCopyActionListCopier.copy(crossRegionCopy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopy(CrossRegionCopyAction ... crossRegionCopy) {
            this.crossRegionCopy(Arrays.asList(crossRegionCopy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopy(Consumer<CrossRegionCopyAction.Builder> ... crossRegionCopy) {
            this.crossRegionCopy(Stream.of(crossRegionCopy).map(c -> (CrossRegionCopyAction)((CrossRegionCopyAction.Builder)CrossRegionCopyAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrossRegionCopy(Collection<CrossRegionCopyAction.BuilderImpl> crossRegionCopy) {
            this.crossRegionCopy = CrossRegionCopyActionListCopier.copyFromBuilder(crossRegionCopy);
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder name(String var1);

        public Builder crossRegionCopy(Collection<CrossRegionCopyAction> var1);

        public Builder crossRegionCopy(CrossRegionCopyAction ... var1);

        public Builder crossRegionCopy(Consumer<CrossRegionCopyAction.Builder> ... var1);
    }
}

