/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.PolicyDetails;
import software.amazon.awssdk.services.dlm.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(LifecyclePolicy.getter(LifecyclePolicy::policyId)).setter(LifecyclePolicy.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LifecyclePolicy.getter(LifecyclePolicy::description)).setter(LifecyclePolicy.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(LifecyclePolicy.getter(LifecyclePolicy::stateAsString)).setter(LifecyclePolicy.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(LifecyclePolicy.getter(LifecyclePolicy::statusMessage)).setter(LifecyclePolicy.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(LifecyclePolicy.getter(LifecyclePolicy::executionRoleArn)).setter(LifecyclePolicy.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(LifecyclePolicy.getter(LifecyclePolicy::dateCreated)).setter(LifecyclePolicy.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(LifecyclePolicy.getter(LifecyclePolicy::dateModified)).setter(LifecyclePolicy.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyDetails").getter(LifecyclePolicy.getter(LifecyclePolicy::policyDetails)).setter(LifecyclePolicy.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(LifecyclePolicy.getter(LifecyclePolicy::tags)).setter(LifecyclePolicy.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(LifecyclePolicy.getter(LifecyclePolicy::policyArn)).setter(LifecyclePolicy.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, DESCRIPTION_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD, POLICY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String description;
    private final String state;
    private final String statusMessage;
    private final String executionRoleArn;
    private final Instant dateCreated;
    private final Instant dateModified;
    private final PolicyDetails policyDetails;
    private final Map<String, String> tags;
    private final String policyArn;

    private LifecyclePolicy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.executionRoleArn = builder.executionRoleArn;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
        this.policyArn = builder.policyArn;
    }

    public String policyId() {
        return this.policyId;
    }

    public String description() {
        return this.description;
    }

    public GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateModified() {
        return this.dateModified;
    }

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified()) && Objects.equals(this.policyDetails(), other.policyDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public String toString() {
        return ToString.builder((String)"LifecyclePolicy").add("PolicyId", (Object)this.policyId()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).add("PolicyDetails", (Object)this.policyDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
            case "PolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String description;
        private String state;
        private String statusMessage;
        private String executionRoleArn;
        private Instant dateCreated;
        private Instant dateModified;
        private PolicyDetails policyDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            this.policyId(model.policyId);
            this.description(model.description);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.executionRoleArn(model.executionRoleArn);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
            this.policyDetails(model.policyDetails);
            this.tags(model.tags);
            this.policyArn(model.policyArn);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicy> {
        public Builder policyId(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(GettablePolicyStateValues var1);

        public Builder statusMessage(String var1);

        public Builder executionRoleArn(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder policyArn(String var1);
    }
}

