/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.PolicyDetails;
import software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLifecyclePolicyRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::executionRoleArn)).setter(CreateLifecyclePolicyRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::description)).setter(CreateLifecyclePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::stateAsString)).setter(CreateLifecyclePolicyRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyDetails").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::policyDetails)).setter(CreateLifecyclePolicyRequest.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::tags)).setter(CreateLifecyclePolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD, DESCRIPTION_FIELD, STATE_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD));
    private final String executionRoleArn;
    private final String description;
    private final String state;
    private final PolicyDetails policyDetails;
    private final Map<String, String> tags;

    private CreateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.executionRoleArn = builder.executionRoleArn;
        this.description = builder.description;
        this.state = builder.state;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public String description() {
        return this.description;
    }

    public SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyRequest)) {
            return false;
        }
        CreateLifecyclePolicyRequest other = (CreateLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.policyDetails(), other.policyDetails()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateLifecyclePolicyRequest").add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("PolicyDetails", (Object)this.policyDetails()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private String executionRoleArn;
        private String description;
        private String state;
        private PolicyDetails policyDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyRequest model) {
            super(model);
            this.executionRoleArn(model.executionRoleArn);
            this.description(model.description);
            this.state(model.state);
            this.policyDetails(model.policyDetails);
            this.tags(model.tags);
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLifecyclePolicyRequest build() {
            return new CreateLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
        public Builder executionRoleArn(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(SettablePolicyStateValues var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

