/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.directoryservicedata.model.AttributeValue;
import software.amazon.awssdk.services.directoryservicedata.model.AttributesCopier;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataResponse;
import software.amazon.awssdk.services.directoryservicedata.model.GroupScope;
import software.amazon.awssdk.services.directoryservicedata.model.GroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupResponse
extends DirectoryServiceDataResponse
implements ToCopyableBuilder<Builder, DescribeGroupResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeGroupResponse.getter(DescribeGroupResponse::directoryId)).setter(DescribeGroupResponse.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistinguishedName").getter(DescribeGroupResponse.getter(DescribeGroupResponse::distinguishedName)).setter(DescribeGroupResponse.setter(Builder::distinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedName").build()}).build();
    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupScope").getter(DescribeGroupResponse.getter(DescribeGroupResponse::groupScopeAsString)).setter(DescribeGroupResponse.setter(Builder::groupScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()}).build();
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupType").getter(DescribeGroupResponse.getter(DescribeGroupResponse::groupTypeAsString)).setter(DescribeGroupResponse.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OtherAttributes").getter(DescribeGroupResponse.getter(DescribeGroupResponse::otherAttributes)).setter(DescribeGroupResponse.setter(Builder::otherAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(DescribeGroupResponse.getter(DescribeGroupResponse::realm)).setter(DescribeGroupResponse.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(DescribeGroupResponse.getter(DescribeGroupResponse::samAccountName)).setter(DescribeGroupResponse.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SID").getter(DescribeGroupResponse.getter(DescribeGroupResponse::sid)).setter(DescribeGroupResponse.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, DISTINGUISHED_NAME_FIELD, GROUP_SCOPE_FIELD, GROUP_TYPE_FIELD, OTHER_ATTRIBUTES_FIELD, REALM_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGroupResponse.memberNameToFieldInitializer();
    private final String directoryId;
    private final String distinguishedName;
    private final String groupScope;
    private final String groupType;
    private final Map<String, AttributeValue> otherAttributes;
    private final String realm;
    private final String samAccountName;
    private final String sid;

    private DescribeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.distinguishedName = builder.distinguishedName;
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.otherAttributes = builder.otherAttributes;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String distinguishedName() {
        return this.distinguishedName;
    }

    public final GroupScope groupScope() {
        return GroupScope.fromValue(this.groupScope);
    }

    public final String groupScopeAsString() {
        return this.groupScope;
    }

    public final GroupType groupType() {
        return GroupType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final boolean hasOtherAttributes() {
        return this.otherAttributes != null && !(this.otherAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> otherAttributes() {
        return this.otherAttributes;
    }

    public final String realm() {
        return this.realm;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    public final String sid() {
        return this.sid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.distinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherAttributes() ? this.otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupResponse)) {
            return false;
        }
        DescribeGroupResponse other = (DescribeGroupResponse)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.distinguishedName(), other.distinguishedName()) && Objects.equals(this.groupScopeAsString(), other.groupScopeAsString()) && Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && this.hasOtherAttributes() == other.hasOtherAttributes() && Objects.equals(this.otherAttributes(), other.otherAttributes()) && Objects.equals(this.realm(), other.realm()) && Objects.equals(this.samAccountName(), other.samAccountName()) && Objects.equals(this.sid(), other.sid());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupResponse").add("DirectoryId", (Object)this.directoryId()).add("DistinguishedName", (Object)(this.distinguishedName() == null ? null : "*** Sensitive Data Redacted ***")).add("GroupScope", (Object)this.groupScopeAsString()).add("GroupType", (Object)this.groupTypeAsString()).add("OtherAttributes", this.hasOtherAttributes() ? this.otherAttributes() : null).add("Realm", (Object)this.realm()).add("SAMAccountName", (Object)this.samAccountName()).add("SID", (Object)this.sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "DistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.distinguishedName()));
            }
            case "GroupScope": {
                return Optional.ofNullable(clazz.cast(this.groupScopeAsString()));
            }
            case "GroupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "OtherAttributes": {
                return Optional.ofNullable(clazz.cast(this.otherAttributes()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
            case "SID": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("DistinguishedName", DISTINGUISHED_NAME_FIELD);
        map.put("GroupScope", GROUP_SCOPE_FIELD);
        map.put("GroupType", GROUP_TYPE_FIELD);
        map.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
        map.put("Realm", REALM_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        map.put("SID", SID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupResponse, T> g) {
        return obj -> g.apply((DescribeGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataResponse.BuilderImpl
    implements Builder {
        private String directoryId;
        private String distinguishedName;
        private String groupScope;
        private String groupType;
        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String realm;
        private String samAccountName;
        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupResponse model) {
            super(model);
            this.directoryId(model.directoryId);
            this.distinguishedName(model.distinguishedName);
            this.groupScope(model.groupScope);
            this.groupType(model.groupType);
            this.otherAttributes(model.otherAttributes);
            this.realm(model.realm);
            this.samAccountName(model.samAccountName);
            this.sid(model.sid);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDistinguishedName() {
            return this.distinguishedName;
        }

        public final void setDistinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
        }

        @Override
        public final Builder distinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public final String getGroupScope() {
            return this.groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public DescribeGroupResponse build() {
            return new DescribeGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryServiceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupResponse> {
        public Builder directoryId(String var1);

        public Builder distinguishedName(String var1);

        public Builder groupScope(String var1);

        public Builder groupScope(GroupScope var1);

        public Builder groupType(String var1);

        public Builder groupType(GroupType var1);

        public Builder otherAttributes(Map<String, AttributeValue> var1);

        public Builder realm(String var1);

        public Builder samAccountName(String var1);

        public Builder sid(String var1);
    }
}

