/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directoryservicedata.model.MemberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberType").getter(Member.getter(Member::memberTypeAsString)).setter(Member.setter(Builder::memberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(Member.getter(Member::samAccountName)).setter(Member.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SID").getter(Member.getter(Member::sid)).setter(Member.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_TYPE_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MemberType", MEMBER_TYPE_FIELD);
            this.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
            this.put("SID", SID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String memberType;
    private final String samAccountName;
    private final String sid;

    private Member(BuilderImpl builder) {
        this.memberType = builder.memberType;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
    }

    public final MemberType memberType() {
        return MemberType.fromValue(this.memberType);
    }

    public final String memberTypeAsString() {
        return this.memberType;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    public final String sid() {
        return this.sid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.memberTypeAsString(), other.memberTypeAsString()) && Objects.equals(this.samAccountName(), other.samAccountName()) && Objects.equals(this.sid(), other.sid());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("MemberType", (Object)this.memberTypeAsString()).add("SAMAccountName", (Object)this.samAccountName()).add("SID", (Object)this.sid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberType": {
                return Optional.ofNullable(clazz.cast(this.memberTypeAsString()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
            case "SID": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberType;
        private String samAccountName;
        private String sid;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.memberType(model.memberType);
            this.samAccountName(model.samAccountName);
            this.sid(model.sid);
        }

        public final String getMemberType() {
            return this.memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder memberType(String var1);

        public Builder memberType(MemberType var1);

        public Builder samAccountName(String var1);

        public Builder sid(String var1);
    }
}

