/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataRequest;
import software.amazon.awssdk.services.directoryservicedata.model.LdapDisplayNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchGroupsRequest
extends DirectoryServiceDataRequest
implements ToCopyableBuilder<Builder, SearchGroupsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(SearchGroupsRequest.getter(SearchGroupsRequest::directoryId)).setter(SearchGroupsRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchGroupsRequest.getter(SearchGroupsRequest::maxResults)).setter(SearchGroupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchGroupsRequest.getter(SearchGroupsRequest::nextToken)).setter(SearchGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(SearchGroupsRequest.getter(SearchGroupsRequest::realm)).setter(SearchGroupsRequest.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<List<String>> SEARCH_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SearchAttributes").getter(SearchGroupsRequest.getter(SearchGroupsRequest::searchAttributes)).setter(SearchGroupsRequest.setter(Builder::searchAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchString").getter(SearchGroupsRequest.getter(SearchGroupsRequest::searchString)).setter(SearchGroupsRequest.setter(Builder::searchString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD, SEARCH_ATTRIBUTES_FIELD, SEARCH_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Realm", REALM_FIELD);
            this.put("SearchAttributes", SEARCH_ATTRIBUTES_FIELD);
            this.put("SearchString", SEARCH_STRING_FIELD);
        }
    });
    private final String directoryId;
    private final Integer maxResults;
    private final String nextToken;
    private final String realm;
    private final List<String> searchAttributes;
    private final String searchString;

    private SearchGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
        this.searchAttributes = builder.searchAttributes;
        this.searchString = builder.searchString;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String realm() {
        return this.realm;
    }

    public final boolean hasSearchAttributes() {
        return this.searchAttributes != null && !(this.searchAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> searchAttributes() {
        return this.searchAttributes;
    }

    public final String searchString() {
        return this.searchString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchAttributes() ? this.searchAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupsRequest)) {
            return false;
        }
        SearchGroupsRequest other = (SearchGroupsRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.realm(), other.realm()) && this.hasSearchAttributes() == other.hasSearchAttributes() && Objects.equals(this.searchAttributes(), other.searchAttributes()) && Objects.equals(this.searchString(), other.searchString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchGroupsRequest").add("DirectoryId", (Object)this.directoryId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Realm", (Object)this.realm()).add("SearchAttributes", this.hasSearchAttributes() ? this.searchAttributes() : null).add("SearchString", (Object)(this.searchString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "SearchAttributes": {
                return Optional.ofNullable(clazz.cast(this.searchAttributes()));
            }
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupsRequest, T> g) {
        return obj -> g.apply((SearchGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private Integer maxResults;
        private String nextToken;
        private String realm;
        private List<String> searchAttributes = DefaultSdkAutoConstructList.getInstance();
        private String searchString;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupsRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.realm(model.realm);
            this.searchAttributes(model.searchAttributes);
            this.searchString(model.searchString);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final Collection<String> getSearchAttributes() {
            if (this.searchAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.searchAttributes;
        }

        public final void setSearchAttributes(Collection<String> searchAttributes) {
            this.searchAttributes = LdapDisplayNameListCopier.copy(searchAttributes);
        }

        @Override
        public final Builder searchAttributes(Collection<String> searchAttributes) {
            this.searchAttributes = LdapDisplayNameListCopier.copy(searchAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchAttributes(String ... searchAttributes) {
            this.searchAttributes(Arrays.asList(searchAttributes));
            return this;
        }

        public final String getSearchString() {
            return this.searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGroupsRequest build() {
            return new SearchGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryServiceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchGroupsRequest> {
        public Builder directoryId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder realm(String var1);

        public Builder searchAttributes(Collection<String> var1);

        public Builder searchAttributes(String ... var1);

        public Builder searchString(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

