/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.Member;

public class ListGroupMembersIterable
implements SdkIterable<ListGroupMembersResponse> {
    private final DirectoryServiceDataClient client;
    private final ListGroupMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupMembersIterable(DirectoryServiceDataClient client, ListGroupMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupMembersResponseFetcher();
    }

    public Iterator<ListGroupMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Member> members() {
        Function<ListGroupMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupMembersResponseFetcher
    implements SyncPageFetcher<ListGroupMembersResponse> {
        private ListGroupMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupMembersResponse nextPage(ListGroupMembersResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembersIterable.this.client.listGroupMembers(ListGroupMembersIterable.this.firstRequest);
            }
            return ListGroupMembersIterable.this.client.listGroupMembers((ListGroupMembersRequest)((Object)ListGroupMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

