/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaExtensionStatus {
    INITIALIZING("Initializing"),
    CREATING_SNAPSHOT("CreatingSnapshot"),
    UPDATING_SCHEMA("UpdatingSchema"),
    REPLICATING("Replicating"),
    CANCEL_IN_PROGRESS("CancelInProgress"),
    ROLLBACK_IN_PROGRESS("RollbackInProgress"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    COMPLETED("Completed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaExtensionStatus> VALUE_MAP;
    private final String value;

    private SchemaExtensionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaExtensionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaExtensionStatus> knownValues() {
        EnumSet<SchemaExtensionStatus> knownValues = EnumSet.allOf(SchemaExtensionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaExtensionStatus.class, SchemaExtensionStatus::toString);
    }
}

