/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AssessmentSummary;
import software.amazon.awssdk.services.directory.model.AssessmentsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAdAssessmentsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, ListAdAssessmentsResponse> {
    private static final SdkField<List<AssessmentSummary>> ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assessments").getter(ListAdAssessmentsResponse.getter(ListAdAssessmentsResponse::assessments)).setter(ListAdAssessmentsResponse.setter(Builder::assessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assessments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAdAssessmentsResponse.getter(ListAdAssessmentsResponse::nextToken)).setter(ListAdAssessmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAdAssessmentsResponse.memberNameToFieldInitializer();
    private final List<AssessmentSummary> assessments;
    private final String nextToken;

    private ListAdAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessments = builder.assessments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessments() {
        return this.assessments != null && !(this.assessments instanceof SdkAutoConstructList);
    }

    public final List<AssessmentSummary> assessments() {
        return this.assessments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessments() ? this.assessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdAssessmentsResponse)) {
            return false;
        }
        ListAdAssessmentsResponse other = (ListAdAssessmentsResponse)((Object)obj);
        return this.hasAssessments() == other.hasAssessments() && Objects.equals(this.assessments(), other.assessments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAdAssessmentsResponse").add("Assessments", this.hasAssessments() ? this.assessments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assessments": {
                return Optional.ofNullable(clazz.cast(this.assessments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Assessments", ASSESSMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAdAssessmentsResponse, T> g) {
        return obj -> g.apply((ListAdAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<AssessmentSummary> assessments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdAssessmentsResponse model) {
            super(model);
            this.assessments(model.assessments);
            this.nextToken(model.nextToken);
        }

        public final List<AssessmentSummary.Builder> getAssessments() {
            List<AssessmentSummary.Builder> result = AssessmentsCopier.copyToBuilder(this.assessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessments(Collection<AssessmentSummary.BuilderImpl> assessments) {
            this.assessments = AssessmentsCopier.copyFromBuilder(assessments);
        }

        @Override
        public final Builder assessments(Collection<AssessmentSummary> assessments) {
            this.assessments = AssessmentsCopier.copy(assessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(AssessmentSummary ... assessments) {
            this.assessments(Arrays.asList(assessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(Consumer<AssessmentSummary.Builder> ... assessments) {
            this.assessments(Stream.of(assessments).map(c -> (AssessmentSummary)((AssessmentSummary.Builder)AssessmentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAdAssessmentsResponse build() {
            return new ListAdAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAdAssessmentsResponse> {
        public Builder assessments(Collection<AssessmentSummary> var1);

        public Builder assessments(AssessmentSummary ... var1);

        public Builder assessments(Consumer<AssessmentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

