/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.CaEnrollmentPolicyStatus;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCaEnrollmentPolicyResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeCaEnrollmentPolicyResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeCaEnrollmentPolicyResponse.getter(DescribeCaEnrollmentPolicyResponse::directoryId)).setter(DescribeCaEnrollmentPolicyResponse.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> PCA_CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcaConnectorArn").getter(DescribeCaEnrollmentPolicyResponse.getter(DescribeCaEnrollmentPolicyResponse::pcaConnectorArn)).setter(DescribeCaEnrollmentPolicyResponse.setter(Builder::pcaConnectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaConnectorArn").build()}).build();
    private static final SdkField<String> CA_ENROLLMENT_POLICY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaEnrollmentPolicyStatus").getter(DescribeCaEnrollmentPolicyResponse.getter(DescribeCaEnrollmentPolicyResponse::caEnrollmentPolicyStatusAsString)).setter(DescribeCaEnrollmentPolicyResponse.setter(Builder::caEnrollmentPolicyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaEnrollmentPolicyStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(DescribeCaEnrollmentPolicyResponse.getter(DescribeCaEnrollmentPolicyResponse::lastUpdatedDateTime)).setter(DescribeCaEnrollmentPolicyResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final SdkField<String> CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaEnrollmentPolicyStatusReason").getter(DescribeCaEnrollmentPolicyResponse.getter(DescribeCaEnrollmentPolicyResponse::caEnrollmentPolicyStatusReason)).setter(DescribeCaEnrollmentPolicyResponse.setter(Builder::caEnrollmentPolicyStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaEnrollmentPolicyStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, PCA_CONNECTOR_ARN_FIELD, CA_ENROLLMENT_POLICY_STATUS_FIELD, LAST_UPDATED_DATE_TIME_FIELD, CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCaEnrollmentPolicyResponse.memberNameToFieldInitializer();
    private final String directoryId;
    private final String pcaConnectorArn;
    private final String caEnrollmentPolicyStatus;
    private final Instant lastUpdatedDateTime;
    private final String caEnrollmentPolicyStatusReason;

    private DescribeCaEnrollmentPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.pcaConnectorArn = builder.pcaConnectorArn;
        this.caEnrollmentPolicyStatus = builder.caEnrollmentPolicyStatus;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.caEnrollmentPolicyStatusReason = builder.caEnrollmentPolicyStatusReason;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String pcaConnectorArn() {
        return this.pcaConnectorArn;
    }

    public final CaEnrollmentPolicyStatus caEnrollmentPolicyStatus() {
        return CaEnrollmentPolicyStatus.fromValue(this.caEnrollmentPolicyStatus);
    }

    public final String caEnrollmentPolicyStatusAsString() {
        return this.caEnrollmentPolicyStatus;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String caEnrollmentPolicyStatusReason() {
        return this.caEnrollmentPolicyStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcaConnectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.caEnrollmentPolicyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.caEnrollmentPolicyStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCaEnrollmentPolicyResponse)) {
            return false;
        }
        DescribeCaEnrollmentPolicyResponse other = (DescribeCaEnrollmentPolicyResponse)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.pcaConnectorArn(), other.pcaConnectorArn()) && Objects.equals(this.caEnrollmentPolicyStatusAsString(), other.caEnrollmentPolicyStatusAsString()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.caEnrollmentPolicyStatusReason(), other.caEnrollmentPolicyStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCaEnrollmentPolicyResponse").add("DirectoryId", (Object)this.directoryId()).add("PcaConnectorArn", (Object)this.pcaConnectorArn()).add("CaEnrollmentPolicyStatus", (Object)this.caEnrollmentPolicyStatusAsString()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("CaEnrollmentPolicyStatusReason", (Object)this.caEnrollmentPolicyStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "PcaConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.pcaConnectorArn()));
            }
            case "CaEnrollmentPolicyStatus": {
                return Optional.ofNullable(clazz.cast(this.caEnrollmentPolicyStatusAsString()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "CaEnrollmentPolicyStatusReason": {
                return Optional.ofNullable(clazz.cast(this.caEnrollmentPolicyStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("PcaConnectorArn", PCA_CONNECTOR_ARN_FIELD);
        map.put("CaEnrollmentPolicyStatus", CA_ENROLLMENT_POLICY_STATUS_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("CaEnrollmentPolicyStatusReason", CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCaEnrollmentPolicyResponse, T> g) {
        return obj -> g.apply((DescribeCaEnrollmentPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private String directoryId;
        private String pcaConnectorArn;
        private String caEnrollmentPolicyStatus;
        private Instant lastUpdatedDateTime;
        private String caEnrollmentPolicyStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCaEnrollmentPolicyResponse model) {
            super(model);
            this.directoryId(model.directoryId);
            this.pcaConnectorArn(model.pcaConnectorArn);
            this.caEnrollmentPolicyStatus(model.caEnrollmentPolicyStatus);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.caEnrollmentPolicyStatusReason(model.caEnrollmentPolicyStatusReason);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getPcaConnectorArn() {
            return this.pcaConnectorArn;
        }

        public final void setPcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
        }

        @Override
        public final Builder pcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
            return this;
        }

        public final String getCaEnrollmentPolicyStatus() {
            return this.caEnrollmentPolicyStatus;
        }

        public final void setCaEnrollmentPolicyStatus(String caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus = caEnrollmentPolicyStatus;
        }

        @Override
        public final Builder caEnrollmentPolicyStatus(String caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus = caEnrollmentPolicyStatus;
            return this;
        }

        @Override
        public final Builder caEnrollmentPolicyStatus(CaEnrollmentPolicyStatus caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus(caEnrollmentPolicyStatus == null ? null : caEnrollmentPolicyStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getCaEnrollmentPolicyStatusReason() {
            return this.caEnrollmentPolicyStatusReason;
        }

        public final void setCaEnrollmentPolicyStatusReason(String caEnrollmentPolicyStatusReason) {
            this.caEnrollmentPolicyStatusReason = caEnrollmentPolicyStatusReason;
        }

        @Override
        public final Builder caEnrollmentPolicyStatusReason(String caEnrollmentPolicyStatusReason) {
            this.caEnrollmentPolicyStatusReason = caEnrollmentPolicyStatusReason;
            return this;
        }

        @Override
        public DescribeCaEnrollmentPolicyResponse build() {
            return new DescribeCaEnrollmentPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCaEnrollmentPolicyResponse> {
        public Builder directoryId(String var1);

        public Builder pcaConnectorArn(String var1);

        public Builder caEnrollmentPolicyStatus(String var1);

        public Builder caEnrollmentPolicyStatus(CaEnrollmentPolicyStatus var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder caEnrollmentPolicyStatusReason(String var1);
    }
}

