/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTrustRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DeleteTrustRequest> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustId").getter(DeleteTrustRequest.getter(DeleteTrustRequest::trustId)).setter(DeleteTrustRequest.setter(Builder::trustId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()}).build();
    private static final SdkField<Boolean> DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteAssociatedConditionalForwarder").getter(DeleteTrustRequest.getter(DeleteTrustRequest::deleteAssociatedConditionalForwarder)).setter(DeleteTrustRequest.setter(Builder::deleteAssociatedConditionalForwarder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAssociatedConditionalForwarder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD, DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteTrustRequest.memberNameToFieldInitializer();
    private final String trustId;
    private final Boolean deleteAssociatedConditionalForwarder;

    private DeleteTrustRequest(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
        this.deleteAssociatedConditionalForwarder = builder.deleteAssociatedConditionalForwarder;
    }

    public final String trustId() {
        return this.trustId;
    }

    public final Boolean deleteAssociatedConditionalForwarder() {
        return this.deleteAssociatedConditionalForwarder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAssociatedConditionalForwarder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrustRequest)) {
            return false;
        }
        DeleteTrustRequest other = (DeleteTrustRequest)((Object)obj);
        return Objects.equals(this.trustId(), other.trustId()) && Objects.equals(this.deleteAssociatedConditionalForwarder(), other.deleteAssociatedConditionalForwarder());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTrustRequest").add("TrustId", (Object)this.trustId()).add("DeleteAssociatedConditionalForwarder", (Object)this.deleteAssociatedConditionalForwarder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustId": {
                return Optional.ofNullable(clazz.cast(this.trustId()));
            }
            case "DeleteAssociatedConditionalForwarder": {
                return Optional.ofNullable(clazz.cast(this.deleteAssociatedConditionalForwarder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustId", TRUST_ID_FIELD);
        map.put("DeleteAssociatedConditionalForwarder", DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrustRequest, T> g) {
        return obj -> g.apply((DeleteTrustRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String trustId;
        private Boolean deleteAssociatedConditionalForwarder;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrustRequest model) {
            super(model);
            this.trustId(model.trustId);
            this.deleteAssociatedConditionalForwarder(model.deleteAssociatedConditionalForwarder);
        }

        public final String getTrustId() {
            return this.trustId;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final Boolean getDeleteAssociatedConditionalForwarder() {
            return this.deleteAssociatedConditionalForwarder;
        }

        public final void setDeleteAssociatedConditionalForwarder(Boolean deleteAssociatedConditionalForwarder) {
            this.deleteAssociatedConditionalForwarder = deleteAssociatedConditionalForwarder;
        }

        @Override
        public final Builder deleteAssociatedConditionalForwarder(Boolean deleteAssociatedConditionalForwarder) {
            this.deleteAssociatedConditionalForwarder = deleteAssociatedConditionalForwarder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrustRequest build() {
            return new DeleteTrustRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTrustRequest> {
        public Builder trustId(String var1);

        public Builder deleteAssociatedConditionalForwarder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

