/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.waiters.DefaultDirectoryAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface DirectoryAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(Consumer<DescribeHybridAdUpdateRequest.Builder> describeHybridAdUpdateRequest) {
        return this.waitUntilHybridADUpdated((DescribeHybridAdUpdateRequest)((Object)((DescribeHybridAdUpdateRequest.Builder)DescribeHybridAdUpdateRequest.builder().applyMutation(describeHybridAdUpdateRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(Consumer<DescribeHybridAdUpdateRequest.Builder> describeHybridAdUpdateRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilHybridADUpdated((DescribeHybridAdUpdateRequest)((Object)((DescribeHybridAdUpdateRequest.Builder)DescribeHybridAdUpdateRequest.builder().applyMutation(describeHybridAdUpdateRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultDirectoryAsyncWaiter.builder();
    }

    public static DirectoryAsyncWaiter create() {
        return DefaultDirectoryAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(DirectoryAsyncClient var1);

        public DirectoryAsyncWaiter build();
    }
}

