/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.waiters.DirectoryWaiter;
import software.amazon.awssdk.services.directory.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultDirectoryWaiter
implements DirectoryWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final DirectoryClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeHybridAdUpdateResponse> hybridADUpdatedWaiter;

    private DefaultDirectoryWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DirectoryClient)DirectoryClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.hybridADUpdatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeHybridAdUpdateResponse.class).acceptors(DefaultDirectoryWaiter.hybridADUpdatedWaiterAcceptors())).overrideConfiguration(DefaultDirectoryWaiter.hybridADUpdatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeHybridAdUpdateResponse> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) {
        return this.hybridADUpdatedWaiter.run(() -> this.client.describeHybridADUpdate(this.applyWaitersUserAgent(describeHybridAdUpdateRequest)));
    }

    @Override
    public WaiterResponse<DescribeHybridAdUpdateResponse> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.hybridADUpdatedWaiter.run(() -> this.client.describeHybridADUpdate(this.applyWaitersUserAgent(describeHybridAdUpdateRequest)), DefaultDirectoryWaiter.hybridADUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>> hybridADUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("UpdateActivities").field("SelfManagedInstances").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Updated"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("UpdateActivities").field("SelfManagedInstances").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UpdateFailed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (UpdateActivities.SelfManagedInstances[].Status=UpdateFailed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration hybridADUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DirectoryWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DirectoryRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DirectoryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DirectoryWaiter.Builder {
        private DirectoryClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public DirectoryWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DirectoryWaiter.Builder client(DirectoryClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DirectoryWaiter build() {
            return new DefaultDirectoryWaiter(this);
        }
    }
}

