/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.AssessmentConfiguration;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAdAssessmentRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, StartAdAssessmentRequest> {
    private static final SdkField<AssessmentConfiguration> ASSESSMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssessmentConfiguration").getter(StartAdAssessmentRequest.getter(StartAdAssessmentRequest::assessmentConfiguration)).setter(StartAdAssessmentRequest.setter(Builder::assessmentConfiguration)).constructor(AssessmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentConfiguration").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(StartAdAssessmentRequest.getter(StartAdAssessmentRequest::directoryId)).setter(StartAdAssessmentRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_CONFIGURATION_FIELD, DIRECTORY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAdAssessmentRequest.memberNameToFieldInitializer();
    private final AssessmentConfiguration assessmentConfiguration;
    private final String directoryId;

    private StartAdAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentConfiguration = builder.assessmentConfiguration;
        this.directoryId = builder.directoryId;
    }

    public final AssessmentConfiguration assessmentConfiguration() {
        return this.assessmentConfiguration;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAdAssessmentRequest)) {
            return false;
        }
        StartAdAssessmentRequest other = (StartAdAssessmentRequest)((Object)obj);
        return Objects.equals(this.assessmentConfiguration(), other.assessmentConfiguration()) && Objects.equals(this.directoryId(), other.directoryId());
    }

    public final String toString() {
        return ToString.builder((String)"StartAdAssessmentRequest").add("AssessmentConfiguration", (Object)this.assessmentConfiguration()).add("DirectoryId", (Object)this.directoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssessmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.assessmentConfiguration()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssessmentConfiguration", ASSESSMENT_CONFIGURATION_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAdAssessmentRequest, T> g) {
        return obj -> g.apply((StartAdAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private AssessmentConfiguration assessmentConfiguration;
        private String directoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAdAssessmentRequest model) {
            super(model);
            this.assessmentConfiguration(model.assessmentConfiguration);
            this.directoryId(model.directoryId);
        }

        public final AssessmentConfiguration.Builder getAssessmentConfiguration() {
            return this.assessmentConfiguration != null ? this.assessmentConfiguration.toBuilder() : null;
        }

        public final void setAssessmentConfiguration(AssessmentConfiguration.BuilderImpl assessmentConfiguration) {
            this.assessmentConfiguration = assessmentConfiguration != null ? assessmentConfiguration.build() : null;
        }

        @Override
        public final Builder assessmentConfiguration(AssessmentConfiguration assessmentConfiguration) {
            this.assessmentConfiguration = assessmentConfiguration;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAdAssessmentRequest build() {
            return new StartAdAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAdAssessmentRequest> {
        public Builder assessmentConfiguration(AssessmentConfiguration var1);

        default public Builder assessmentConfiguration(Consumer<AssessmentConfiguration.Builder> assessmentConfiguration) {
            return this.assessmentConfiguration((AssessmentConfiguration)((AssessmentConfiguration.Builder)AssessmentConfiguration.builder().applyMutation(assessmentConfiguration)).build());
        }

        public Builder directoryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

