/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AdditionalRegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionsInfo> {
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryRegion").getter(RegionsInfo.getter(RegionsInfo::primaryRegion)).setter(RegionsInfo.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalRegions").getter(RegionsInfo.getter(RegionsInfo::additionalRegions)).setter(RegionsInfo.setter(Builder::additionalRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_REGION_FIELD, ADDITIONAL_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegionsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String primaryRegion;
    private final List<String> additionalRegions;

    private RegionsInfo(BuilderImpl builder) {
        this.primaryRegion = builder.primaryRegion;
        this.additionalRegions = builder.additionalRegions;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    public final boolean hasAdditionalRegions() {
        return this.additionalRegions != null && !(this.additionalRegions instanceof SdkAutoConstructList);
    }

    public final List<String> additionalRegions() {
        return this.additionalRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalRegions() ? this.additionalRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionsInfo)) {
            return false;
        }
        RegionsInfo other = (RegionsInfo)obj;
        return Objects.equals(this.primaryRegion(), other.primaryRegion()) && this.hasAdditionalRegions() == other.hasAdditionalRegions() && Objects.equals(this.additionalRegions(), other.additionalRegions());
    }

    public final String toString() {
        return ToString.builder((String)"RegionsInfo").add("PrimaryRegion", (Object)this.primaryRegion()).add("AdditionalRegions", this.hasAdditionalRegions() ? this.additionalRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
            case "AdditionalRegions": {
                return Optional.ofNullable(clazz.cast(this.additionalRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrimaryRegion", PRIMARY_REGION_FIELD);
        map.put("AdditionalRegions", ADDITIONAL_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionsInfo, T> g) {
        return obj -> g.apply((RegionsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryRegion;
        private List<String> additionalRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegionsInfo model) {
            this.primaryRegion(model.primaryRegion);
            this.additionalRegions(model.additionalRegions);
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final Collection<String> getAdditionalRegions() {
            if (this.additionalRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalRegions;
        }

        public final void setAdditionalRegions(Collection<String> additionalRegions) {
            this.additionalRegions = AdditionalRegionsCopier.copy(additionalRegions);
        }

        @Override
        public final Builder additionalRegions(Collection<String> additionalRegions) {
            this.additionalRegions = AdditionalRegionsCopier.copy(additionalRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalRegions(String ... additionalRegions) {
            this.additionalRegions(Arrays.asList(additionalRegions));
            return this;
        }

        public RegionsInfo build() {
            return new RegionsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionsInfo> {
        public Builder primaryRegion(String var1);

        public Builder additionalRegions(Collection<String> var1);

        public Builder additionalRegions(String ... var1);
    }
}

