/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DnsIpv6AddrsCopier;
import software.amazon.awssdk.services.directory.model.NetworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkUpdateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkUpdateSettings> {
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(NetworkUpdateSettings.getter(NetworkUpdateSettings::networkTypeAsString)).setter(NetworkUpdateSettings.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIpsV6").getter(NetworkUpdateSettings.getter(NetworkUpdateSettings::customerDnsIpsV6)).setter(NetworkUpdateSettings.setter(Builder::customerDnsIpsV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIpsV6").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_TYPE_FIELD, CUSTOMER_DNS_IPS_V6_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkUpdateSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkType;
    private final List<String> customerDnsIpsV6;

    private NetworkUpdateSettings(BuilderImpl builder) {
        this.networkType = builder.networkType;
        this.customerDnsIpsV6 = builder.customerDnsIpsV6;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final boolean hasCustomerDnsIpsV6() {
        return this.customerDnsIpsV6 != null && !(this.customerDnsIpsV6 instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIpsV6() {
        return this.customerDnsIpsV6;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIpsV6() ? this.customerDnsIpsV6() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkUpdateSettings)) {
            return false;
        }
        NetworkUpdateSettings other = (NetworkUpdateSettings)obj;
        return Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && this.hasCustomerDnsIpsV6() == other.hasCustomerDnsIpsV6() && Objects.equals(this.customerDnsIpsV6(), other.customerDnsIpsV6());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkUpdateSettings").add("NetworkType", (Object)this.networkTypeAsString()).add("CustomerDnsIpsV6", this.hasCustomerDnsIpsV6() ? this.customerDnsIpsV6() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "CustomerDnsIpsV6": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIpsV6()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("CustomerDnsIpsV6", CUSTOMER_DNS_IPS_V6_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkUpdateSettings, T> g) {
        return obj -> g.apply((NetworkUpdateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkType;
        private List<String> customerDnsIpsV6 = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkUpdateSettings model) {
            this.networkType(model.networkType);
            this.customerDnsIpsV6(model.customerDnsIpsV6);
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final Collection<String> getCustomerDnsIpsV6() {
            if (this.customerDnsIpsV6 instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIpsV6;
        }

        public final void setCustomerDnsIpsV6(Collection<String> customerDnsIpsV6) {
            this.customerDnsIpsV6 = DnsIpv6AddrsCopier.copy(customerDnsIpsV6);
        }

        @Override
        public final Builder customerDnsIpsV6(Collection<String> customerDnsIpsV6) {
            this.customerDnsIpsV6 = DnsIpv6AddrsCopier.copy(customerDnsIpsV6);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIpsV6(String ... customerDnsIpsV6) {
            this.customerDnsIpsV6(Arrays.asList(customerDnsIpsV6));
            return this;
        }

        public NetworkUpdateSettings build() {
            return new NetworkUpdateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkUpdateSettings> {
        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder customerDnsIpsV6(Collection<String> var1);

        public Builder customerDnsIpsV6(String ... var1);
    }
}

