/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UpdateInfoEntry;

public class DescribeUpdateDirectoryPublisher
implements SdkPublisher<DescribeUpdateDirectoryResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeUpdateDirectoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUpdateDirectoryPublisher(DirectoryAsyncClient client, DescribeUpdateDirectoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUpdateDirectoryPublisher(DirectoryAsyncClient client, DescribeUpdateDirectoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUpdateDirectoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUpdateDirectoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UpdateInfoEntry> updateActivities() {
        Function<DescribeUpdateDirectoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateActivities() != null) {
                return response.updateActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeUpdateDirectoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeUpdateDirectoryResponseFetcher
    implements AsyncPageFetcher<DescribeUpdateDirectoryResponse> {
        private DescribeUpdateDirectoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUpdateDirectoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeUpdateDirectoryResponse> nextPage(DescribeUpdateDirectoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeUpdateDirectoryPublisher.this.client.describeUpdateDirectory(DescribeUpdateDirectoryPublisher.this.firstRequest);
            }
            return DescribeUpdateDirectoryPublisher.this.client.describeUpdateDirectory((DescribeUpdateDirectoryRequest)((Object)DescribeUpdateDirectoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

