/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrustState {
    CREATING("Creating"),
    CREATED("Created"),
    VERIFYING("Verifying"),
    VERIFY_FAILED("VerifyFailed"),
    VERIFIED("Verified"),
    UPDATING("Updating"),
    UPDATE_FAILED("UpdateFailed"),
    UPDATED("Updated"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrustState> VALUE_MAP;
    private final String value;

    private TrustState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustState> knownValues() {
        EnumSet<TrustState> knownValues = EnumSet.allOf(TrustState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrustState.class, TrustState::toString);
    }
}

