/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DirectoryStage {
    REQUESTED("Requested"),
    CREATING("Creating"),
    CREATED("Created"),
    ACTIVE("Active"),
    INOPERABLE("Inoperable"),
    IMPAIRED("Impaired"),
    RESTORING("Restoring"),
    RESTORE_FAILED("RestoreFailed"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DirectoryStage> VALUE_MAP;
    private final String value;

    private DirectoryStage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryStage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryStage> knownValues() {
        EnumSet<DirectoryStage> knownValues = EnumSet.allOf(DirectoryStage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DirectoryStage.class, DirectoryStage::toString);
    }
}

