/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaExtensionsResponse extends DirectoryResponse implements
        ToCopyableBuilder<ListSchemaExtensionsResponse.Builder, ListSchemaExtensionsResponse> {
    private static final SdkField<List<SchemaExtensionInfo>> SCHEMA_EXTENSIONS_INFO_FIELD = SdkField
            .<List<SchemaExtensionInfo>> builder(MarshallingType.LIST)
            .memberName("SchemaExtensionsInfo")
            .getter(getter(ListSchemaExtensionsResponse::schemaExtensionsInfo))
            .setter(setter(Builder::schemaExtensionsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaExtensionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaExtensionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemaExtensionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_EXTENSIONS_INFO_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SchemaExtensionInfo> schemaExtensionsInfo;

    private final String nextToken;

    private ListSchemaExtensionsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaExtensionsInfo = builder.schemaExtensionsInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaExtensionsInfo property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSchemaExtensionsInfo() {
        return schemaExtensionsInfo != null && !(schemaExtensionsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the schema extensions applied to the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaExtensionsInfo} method.
     * </p>
     * 
     * @return Information about the schema extensions applied to the directory.
     */
    public final List<SchemaExtensionInfo> schemaExtensionsInfo() {
        return schemaExtensionsInfo;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent
     * call to <code>ListSchemaExtensions</code> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
     *         subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaExtensionsInfo() ? schemaExtensionsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaExtensionsResponse)) {
            return false;
        }
        ListSchemaExtensionsResponse other = (ListSchemaExtensionsResponse) obj;
        return hasSchemaExtensionsInfo() == other.hasSchemaExtensionsInfo()
                && Objects.equals(schemaExtensionsInfo(), other.schemaExtensionsInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemaExtensionsResponse")
                .add("SchemaExtensionsInfo", hasSchemaExtensionsInfo() ? schemaExtensionsInfo() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaExtensionsInfo":
            return Optional.ofNullable(clazz.cast(schemaExtensionsInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaExtensionsResponse, T> g) {
        return obj -> g.apply((ListSchemaExtensionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemaExtensionsResponse> {
        /**
         * <p>
         * Information about the schema extensions applied to the directory.
         * </p>
         * 
         * @param schemaExtensionsInfo
         *        Information about the schema extensions applied to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaExtensionsInfo(Collection<SchemaExtensionInfo> schemaExtensionsInfo);

        /**
         * <p>
         * Information about the schema extensions applied to the directory.
         * </p>
         * 
         * @param schemaExtensionsInfo
         *        Information about the schema extensions applied to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaExtensionsInfo(SchemaExtensionInfo... schemaExtensionsInfo);

        /**
         * <p>
         * Information about the schema extensions applied to the directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.SchemaExtensionInfo.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.directory.model.SchemaExtensionInfo#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.SchemaExtensionInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaExtensionsInfo(List<SchemaExtensionInfo>)}.
         * 
         * @param schemaExtensionsInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.SchemaExtensionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaExtensionsInfo(java.util.Collection<SchemaExtensionInfo>)
         */
        Builder schemaExtensionsInfo(Consumer<SchemaExtensionInfo.Builder>... schemaExtensionsInfo);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         * subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         *        subsequent call to <code>ListSchemaExtensions</code> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<SchemaExtensionInfo> schemaExtensionsInfo = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaExtensionsResponse model) {
            super(model);
            schemaExtensionsInfo(model.schemaExtensionsInfo);
            nextToken(model.nextToken);
        }

        public final List<SchemaExtensionInfo.Builder> getSchemaExtensionsInfo() {
            List<SchemaExtensionInfo.Builder> result = SchemaExtensionsInfoCopier.copyToBuilder(this.schemaExtensionsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaExtensionsInfo(Collection<SchemaExtensionInfo.BuilderImpl> schemaExtensionsInfo) {
            this.schemaExtensionsInfo = SchemaExtensionsInfoCopier.copyFromBuilder(schemaExtensionsInfo);
        }

        @Override
        public final Builder schemaExtensionsInfo(Collection<SchemaExtensionInfo> schemaExtensionsInfo) {
            this.schemaExtensionsInfo = SchemaExtensionsInfoCopier.copy(schemaExtensionsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaExtensionsInfo(SchemaExtensionInfo... schemaExtensionsInfo) {
            schemaExtensionsInfo(Arrays.asList(schemaExtensionsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaExtensionsInfo(Consumer<SchemaExtensionInfo.Builder>... schemaExtensionsInfo) {
            schemaExtensionsInfo(Stream.of(schemaExtensionsInfo).map(c -> SchemaExtensionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchemaExtensionsResponse build() {
            return new ListSchemaExtensionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
