/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.IpRouteInfo;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;

public class ListIpRoutesIterable
implements SdkIterable<ListIpRoutesResponse> {
    private final DirectoryClient client;
    private final ListIpRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIpRoutesIterable(DirectoryClient client, ListIpRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIpRoutesResponseFetcher();
    }

    public Iterator<ListIpRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpRouteInfo> ipRoutesInfo() {
        Function<ListIpRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipRoutesInfo() != null) {
                return response.ipRoutesInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIpRoutesResponseFetcher
    implements SyncPageFetcher<ListIpRoutesResponse> {
        private ListIpRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListIpRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIpRoutesResponse nextPage(ListIpRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListIpRoutesIterable.this.client.listIpRoutes(ListIpRoutesIterable.this.firstRequest);
            }
            return ListIpRoutesIterable.this.client.listIpRoutes((ListIpRoutesRequest)((Object)ListIpRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

