/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Cloud WAN core network that the Direct Connect gateway is associated to. This is only
 * returned when a Direct Connect gateway is associated to a Cloud WAN core network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedCoreNetwork implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedCoreNetwork.Builder, AssociatedCoreNetwork> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssociatedCoreNetwork::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(AssociatedCoreNetwork::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentId").getter(getter(AssociatedCoreNetwork::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, OWNER_ACCOUNT_FIELD,
            ATTACHMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String ownerAccount;

    private final String attachmentId;

    private AssociatedCoreNetwork(BuilderImpl builder) {
        this.id = builder.id;
        this.ownerAccount = builder.ownerAccount;
        this.attachmentId = builder.attachmentId;
    }

    /**
     * <p>
     * The ID of the Cloud WAN core network that the Direct Connect gateway is associated to.
     * </p>
     * 
     * @return The ID of the Cloud WAN core network that the Direct Connect gateway is associated to.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The account owner of the Cloud WAN core network.
     * </p>
     * 
     * @return The account owner of the Cloud WAN core network.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * the ID of the Direct Connect gateway attachment.
     * </p>
     * 
     * @return the ID of the Direct Connect gateway attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedCoreNetwork)) {
            return false;
        }
        AssociatedCoreNetwork other = (AssociatedCoreNetwork) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(attachmentId(), other.attachmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedCoreNetwork").add("Id", id()).add("OwnerAccount", ownerAccount())
                .add("AttachmentId", attachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedCoreNetwork, T> g) {
        return obj -> g.apply((AssociatedCoreNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedCoreNetwork> {
        /**
         * <p>
         * The ID of the Cloud WAN core network that the Direct Connect gateway is associated to.
         * </p>
         * 
         * @param id
         *        The ID of the Cloud WAN core network that the Direct Connect gateway is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The account owner of the Cloud WAN core network.
         * </p>
         * 
         * @param ownerAccount
         *        The account owner of the Cloud WAN core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * the ID of the Direct Connect gateway attachment.
         * </p>
         * 
         * @param attachmentId
         *        the ID of the Direct Connect gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String ownerAccount;

        private String attachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedCoreNetwork model) {
            id(model.id);
            ownerAccount(model.ownerAccount);
            attachmentId(model.attachmentId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        @Override
        public AssociatedCoreNetwork build() {
            return new AssociatedCoreNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
