/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.ConnectionState;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy;
import software.amazon.awssdk.services.directconnect.model.MacSecKey;
import software.amazon.awssdk.services.directconnect.model.MacSecKeyListCopier;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, CreateConnectionResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(CreateConnectionResponse.getter(CreateConnectionResponse::ownerAccount)).setter(CreateConnectionResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(CreateConnectionResponse.getter(CreateConnectionResponse::connectionId)).setter(CreateConnectionResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionName").getter(CreateConnectionResponse.getter(CreateConnectionResponse::connectionName)).setter(CreateConnectionResponse.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionState").getter(CreateConnectionResponse.getter(CreateConnectionResponse::connectionStateAsString)).setter(CreateConnectionResponse.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(CreateConnectionResponse.getter(CreateConnectionResponse::region)).setter(CreateConnectionResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(CreateConnectionResponse.getter(CreateConnectionResponse::location)).setter(CreateConnectionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bandwidth").getter(CreateConnectionResponse.getter(CreateConnectionResponse::bandwidth)).setter(CreateConnectionResponse.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(CreateConnectionResponse.getter(CreateConnectionResponse::vlan)).setter(CreateConnectionResponse.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnerName").getter(CreateConnectionResponse.getter(CreateConnectionResponse::partnerName)).setter(CreateConnectionResponse.setter(Builder::partnerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerName").build()}).build();
    private static final SdkField<Instant> LOA_ISSUE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("loaIssueTime").getter(CreateConnectionResponse.getter(CreateConnectionResponse::loaIssueTime)).setter(CreateConnectionResponse.setter(Builder::loaIssueTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaIssueTime").build()}).build();
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagId").getter(CreateConnectionResponse.getter(CreateConnectionResponse::lagId)).setter(CreateConnectionResponse.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDevice").getter(CreateConnectionResponse.getter(CreateConnectionResponse::awsDevice)).setter(CreateConnectionResponse.setter(Builder::awsDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("jumboFrameCapable").getter(CreateConnectionResponse.getter(CreateConnectionResponse::jumboFrameCapable)).setter(CreateConnectionResponse.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDeviceV2").getter(CreateConnectionResponse.getter(CreateConnectionResponse::awsDeviceV2)).setter(CreateConnectionResponse.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsLogicalDeviceId").getter(CreateConnectionResponse.getter(CreateConnectionResponse::awsLogicalDeviceId)).setter(CreateConnectionResponse.setter(Builder::awsLogicalDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build()}).build();
    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hasLogicalRedundancy").getter(CreateConnectionResponse.getter(CreateConnectionResponse::hasLogicalRedundancyAsString)).setter(CreateConnectionResponse.setter(Builder::hasLogicalRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateConnectionResponse.getter(CreateConnectionResponse::tags)).setter(CreateConnectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(CreateConnectionResponse.getter(CreateConnectionResponse::providerName)).setter(CreateConnectionResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<Boolean> MAC_SEC_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("macSecCapable").getter(CreateConnectionResponse.getter(CreateConnectionResponse::macSecCapable)).setter(CreateConnectionResponse.setter(Builder::macSecCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecCapable").build()}).build();
    private static final SdkField<String> PORT_ENCRYPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portEncryptionStatus").getter(CreateConnectionResponse.getter(CreateConnectionResponse::portEncryptionStatus)).setter(CreateConnectionResponse.setter(Builder::portEncryptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portEncryptionStatus").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionMode").getter(CreateConnectionResponse.getter(CreateConnectionResponse::encryptionMode)).setter(CreateConnectionResponse.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()}).build();
    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("macSecKeys").getter(CreateConnectionResponse.getter(CreateConnectionResponse::macSecKeys)).setter(CreateConnectionResponse.setter(Builder::macSecKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MacSecKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD, CONNECTION_ID_FIELD, CONNECTION_NAME_FIELD, CONNECTION_STATE_FIELD, REGION_FIELD, LOCATION_FIELD, BANDWIDTH_FIELD, VLAN_FIELD, PARTNER_NAME_FIELD, LOA_ISSUE_TIME_FIELD, LAG_ID_FIELD, AWS_DEVICE_FIELD, JUMBO_FRAME_CAPABLE_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD, MAC_SEC_CAPABLE_FIELD, PORT_ENCRYPTION_STATUS_FIELD, ENCRYPTION_MODE_FIELD, MAC_SEC_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionResponse.memberNameToFieldInitializer();
    private final String ownerAccount;
    private final String connectionId;
    private final String connectionName;
    private final String connectionState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Integer vlan;
    private final String partnerName;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final Boolean jumboFrameCapable;
    private final String awsDeviceV2;
    private final String awsLogicalDeviceId;
    private final String hasLogicalRedundancy;
    private final List<Tag> tags;
    private final String providerName;
    private final Boolean macSecCapable;
    private final String portEncryptionStatus;
    private final String encryptionMode;
    private final List<MacSecKey> macSecKeys;

    private CreateConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.connectionId = builder.connectionId;
        this.connectionName = builder.connectionName;
        this.connectionState = builder.connectionState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.vlan = builder.vlan;
        this.partnerName = builder.partnerName;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
        this.macSecCapable = builder.macSecCapable;
        this.portEncryptionStatus = builder.portEncryptionStatus;
        this.encryptionMode = builder.encryptionMode;
        this.macSecKeys = builder.macSecKeys;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final String region() {
        return this.region;
    }

    public final String location() {
        return this.location;
    }

    public final String bandwidth() {
        return this.bandwidth;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final String partnerName() {
        return this.partnerName;
    }

    public final Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public final String lagId() {
        return this.lagId;
    }

    public final String awsDevice() {
        return this.awsDevice;
    }

    public final Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public final String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public final String awsLogicalDeviceId() {
        return this.awsLogicalDeviceId;
    }

    public final HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(this.hasLogicalRedundancy);
    }

    public final String hasLogicalRedundancyAsString() {
        return this.hasLogicalRedundancy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final Boolean macSecCapable() {
        return this.macSecCapable;
    }

    public final String portEncryptionStatus() {
        return this.portEncryptionStatus;
    }

    public final String encryptionMode() {
        return this.encryptionMode;
    }

    public final boolean hasMacSecKeys() {
        return this.macSecKeys != null && !(this.macSecKeys instanceof SdkAutoConstructList);
    }

    public final List<MacSecKey> macSecKeys() {
        return this.macSecKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.macSecCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.portEncryptionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacSecKeys() ? this.macSecKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionResponse)) {
            return false;
        }
        CreateConnectionResponse other = (CreateConnectionResponse)((Object)obj);
        return Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.partnerName(), other.partnerName()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.awsLogicalDeviceId(), other.awsLogicalDeviceId()) && Objects.equals(this.hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.macSecCapable(), other.macSecCapable()) && Objects.equals(this.portEncryptionStatus(), other.portEncryptionStatus()) && Objects.equals(this.encryptionMode(), other.encryptionMode()) && this.hasMacSecKeys() == other.hasMacSecKeys() && Objects.equals(this.macSecKeys(), other.macSecKeys());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionResponse").add("OwnerAccount", (Object)this.ownerAccount()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionName", (Object)this.connectionName()).add("ConnectionState", (Object)this.connectionStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("Vlan", (Object)this.vlan()).add("PartnerName", (Object)this.partnerName()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("AwsLogicalDeviceId", (Object)this.awsLogicalDeviceId()).add("HasLogicalRedundancy", (Object)this.hasLogicalRedundancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ProviderName", (Object)this.providerName()).add("MacSecCapable", (Object)this.macSecCapable()).add("PortEncryptionStatus", (Object)this.portEncryptionStatus()).add("EncryptionMode", (Object)this.encryptionMode()).add("MacSecKeys", this.hasMacSecKeys() ? this.macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "connectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "connectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "partnerName": {
                return Optional.ofNullable(clazz.cast(this.partnerName()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "awsLogicalDeviceId": {
                return Optional.ofNullable(clazz.cast(this.awsLogicalDeviceId()));
            }
            case "hasLogicalRedundancy": {
                return Optional.ofNullable(clazz.cast(this.hasLogicalRedundancyAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "macSecCapable": {
                return Optional.ofNullable(clazz.cast(this.macSecCapable()));
            }
            case "portEncryptionStatus": {
                return Optional.ofNullable(clazz.cast(this.portEncryptionStatus()));
            }
            case "encryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionMode()));
            }
            case "macSecKeys": {
                return Optional.ofNullable(clazz.cast(this.macSecKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("connectionName", CONNECTION_NAME_FIELD);
        map.put("connectionState", CONNECTION_STATE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("bandwidth", BANDWIDTH_FIELD);
        map.put("vlan", VLAN_FIELD);
        map.put("partnerName", PARTNER_NAME_FIELD);
        map.put("loaIssueTime", LOA_ISSUE_TIME_FIELD);
        map.put("lagId", LAG_ID_FIELD);
        map.put("awsDevice", AWS_DEVICE_FIELD);
        map.put("jumboFrameCapable", JUMBO_FRAME_CAPABLE_FIELD);
        map.put("awsDeviceV2", AWS_DEVICE_V2_FIELD);
        map.put("awsLogicalDeviceId", AWS_LOGICAL_DEVICE_ID_FIELD);
        map.put("hasLogicalRedundancy", HAS_LOGICAL_REDUNDANCY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("macSecCapable", MAC_SEC_CAPABLE_FIELD);
        map.put("portEncryptionStatus", PORT_ENCRYPTION_STATUS_FIELD);
        map.put("encryptionMode", ENCRYPTION_MODE_FIELD);
        map.put("macSecKeys", MAC_SEC_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionResponse, T> g) {
        return obj -> g.apply((CreateConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String connectionId;
        private String connectionName;
        private String connectionState;
        private String region;
        private String location;
        private String bandwidth;
        private Integer vlan;
        private String partnerName;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private Boolean jumboFrameCapable;
        private String awsDeviceV2;
        private String awsLogicalDeviceId;
        private String hasLogicalRedundancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String providerName;
        private Boolean macSecCapable;
        private String portEncryptionStatus;
        private String encryptionMode;
        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionResponse model) {
            super(model);
            this.ownerAccount(model.ownerAccount);
            this.connectionId(model.connectionId);
            this.connectionName(model.connectionName);
            this.connectionState(model.connectionState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.vlan(model.vlan);
            this.partnerName(model.partnerName);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.awsDeviceV2(model.awsDeviceV2);
            this.awsLogicalDeviceId(model.awsLogicalDeviceId);
            this.hasLogicalRedundancy(model.hasLogicalRedundancy);
            this.tags(model.tags);
            this.providerName(model.providerName);
            this.macSecCapable(model.macSecCapable);
            this.portEncryptionStatus(model.portEncryptionStatus);
            this.encryptionMode(model.encryptionMode);
            this.macSecKeys(model.macSecKeys);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getPartnerName() {
            return this.partnerName;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final String getLagId() {
            return this.lagId;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return this.awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final String getHasLogicalRedundancy() {
            return this.hasLogicalRedundancy;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Boolean getMacSecCapable() {
            return this.macSecCapable;
        }

        public final void setMacSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
        }

        @Override
        public final Builder macSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
            return this;
        }

        public final String getPortEncryptionStatus() {
            return this.portEncryptionStatus;
        }

        public final void setPortEncryptionStatus(String portEncryptionStatus) {
            this.portEncryptionStatus = portEncryptionStatus;
        }

        @Override
        public final Builder portEncryptionStatus(String portEncryptionStatus) {
            this.portEncryptionStatus = portEncryptionStatus;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        public final List<MacSecKey.Builder> getMacSecKeys() {
            List<MacSecKey.Builder> result = MacSecKeyListCopier.copyToBuilder(this.macSecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey ... macSecKeys) {
            this.macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder> ... macSecKeys) {
            this.macSecKeys(Stream.of(macSecKeys).map(c -> (MacSecKey)((MacSecKey.Builder)MacSecKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateConnectionResponse build() {
            return new CreateConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionResponse> {
        public Builder ownerAccount(String var1);

        public Builder connectionId(String var1);

        public Builder connectionName(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder vlan(Integer var1);

        public Builder partnerName(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder awsDeviceV2(String var1);

        public Builder awsLogicalDeviceId(String var1);

        public Builder hasLogicalRedundancy(String var1);

        public Builder hasLogicalRedundancy(HasLogicalRedundancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder providerName(String var1);

        public Builder macSecCapable(Boolean var1);

        public Builder portEncryptionStatus(String var1);

        public Builder encryptionMode(String var1);

        public Builder macSecKeys(Collection<MacSecKey> var1);

        public Builder macSecKeys(MacSecKey ... var1);

        public Builder macSecKeys(Consumer<MacSecKey.Builder> ... var1);
    }
}

