/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBgpPeerRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DeleteBgpPeerRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(DeleteBgpPeerRequest.getter(DeleteBgpPeerRequest::virtualInterfaceId)).setter(DeleteBgpPeerRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<Integer> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("asn").getter(DeleteBgpPeerRequest.getter(DeleteBgpPeerRequest::asn)).setter(DeleteBgpPeerRequest.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerAddress").getter(DeleteBgpPeerRequest.getter(DeleteBgpPeerRequest::customerAddress)).setter(DeleteBgpPeerRequest.setter(Builder::customerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()}).build();
    private static final SdkField<String> BGP_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bgpPeerId").getter(DeleteBgpPeerRequest.getter(DeleteBgpPeerRequest::bgpPeerId)).setter(DeleteBgpPeerRequest.setter(Builder::bgpPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, ASN_FIELD, CUSTOMER_ADDRESS_FIELD, BGP_PEER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteBgpPeerRequest.memberNameToFieldInitializer();
    private final String virtualInterfaceId;
    private final Integer asn;
    private final String customerAddress;
    private final String bgpPeerId;

    private DeleteBgpPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.asn = builder.asn;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerId = builder.bgpPeerId;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final Integer asn() {
        return this.asn;
    }

    public final String customerAddress() {
        return this.customerAddress;
    }

    public final String bgpPeerId() {
        return this.bgpPeerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpPeerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBgpPeerRequest)) {
            return false;
        }
        DeleteBgpPeerRequest other = (DeleteBgpPeerRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.bgpPeerId(), other.bgpPeerId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBgpPeerRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Asn", (Object)this.asn()).add("CustomerAddress", (Object)this.customerAddress()).add("BgpPeerId", (Object)this.bgpPeerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
            case "bgpPeerId": {
                return Optional.ofNullable(clazz.cast(this.bgpPeerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("asn", ASN_FIELD);
        map.put("customerAddress", CUSTOMER_ADDRESS_FIELD);
        map.put("bgpPeerId", BGP_PEER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBgpPeerRequest, T> g) {
        return obj -> g.apply((DeleteBgpPeerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private Integer asn;
        private String customerAddress;
        private String bgpPeerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBgpPeerRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.asn(model.asn);
            this.customerAddress(model.customerAddress);
            this.bgpPeerId(model.bgpPeerId);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getBgpPeerId() {
            return this.bgpPeerId;
        }

        public final void setBgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
        }

        @Override
        public final Builder bgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBgpPeerRequest build() {
            return new DeleteBgpPeerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBgpPeerRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder asn(Integer var1);

        public Builder customerAddress(String var1);

        public Builder bgpPeerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

