/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VirtualInterfaceState {
    CONFIRMING("confirming"),
    VERIFYING("verifying"),
    PENDING("pending"),
    AVAILABLE("available"),
    DOWN("down"),
    DELETING("deleting"),
    DELETED("deleted"),
    REJECTED("rejected"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VirtualInterfaceState> VALUE_MAP;
    private final String value;

    private VirtualInterfaceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VirtualInterfaceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VirtualInterfaceState> knownValues() {
        EnumSet<VirtualInterfaceState> knownValues = EnumSet.allOf(VirtualInterfaceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VirtualInterfaceState.class, VirtualInterfaceState::toString);
    }
}

