/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AgreementListCopier;
import software.amazon.awssdk.services.directconnect.model.CustomerAgreement;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.NniPartnerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomerMetadataResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeCustomerMetadataResponse> {
    private static final SdkField<List<CustomerAgreement>> AGREEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agreements").getter(DescribeCustomerMetadataResponse.getter(DescribeCustomerMetadataResponse::agreements)).setter(DescribeCustomerMetadataResponse.setter(Builder::agreements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerAgreement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NNI_PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nniPartnerType").getter(DescribeCustomerMetadataResponse.getter(DescribeCustomerMetadataResponse::nniPartnerTypeAsString)).setter(DescribeCustomerMetadataResponse.setter(Builder::nniPartnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nniPartnerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENTS_FIELD, NNI_PARTNER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCustomerMetadataResponse.memberNameToFieldInitializer();
    private final List<CustomerAgreement> agreements;
    private final String nniPartnerType;

    private DescribeCustomerMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.agreements = builder.agreements;
        this.nniPartnerType = builder.nniPartnerType;
    }

    public final boolean hasAgreements() {
        return this.agreements != null && !(this.agreements instanceof SdkAutoConstructList);
    }

    public final List<CustomerAgreement> agreements() {
        return this.agreements;
    }

    public final NniPartnerType nniPartnerType() {
        return NniPartnerType.fromValue(this.nniPartnerType);
    }

    public final String nniPartnerTypeAsString() {
        return this.nniPartnerType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgreements() ? this.agreements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nniPartnerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerMetadataResponse)) {
            return false;
        }
        DescribeCustomerMetadataResponse other = (DescribeCustomerMetadataResponse)((Object)obj);
        return this.hasAgreements() == other.hasAgreements() && Objects.equals(this.agreements(), other.agreements()) && Objects.equals(this.nniPartnerTypeAsString(), other.nniPartnerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomerMetadataResponse").add("Agreements", this.hasAgreements() ? this.agreements() : null).add("NniPartnerType", (Object)this.nniPartnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agreements": {
                return Optional.ofNullable(clazz.cast(this.agreements()));
            }
            case "nniPartnerType": {
                return Optional.ofNullable(clazz.cast(this.nniPartnerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agreements", AGREEMENTS_FIELD);
        map.put("nniPartnerType", NNI_PARTNER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerMetadataResponse, T> g) {
        return obj -> g.apply((DescribeCustomerMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<CustomerAgreement> agreements = DefaultSdkAutoConstructList.getInstance();
        private String nniPartnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerMetadataResponse model) {
            super(model);
            this.agreements(model.agreements);
            this.nniPartnerType(model.nniPartnerType);
        }

        public final List<CustomerAgreement.Builder> getAgreements() {
            List<CustomerAgreement.Builder> result = AgreementListCopier.copyToBuilder(this.agreements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgreements(Collection<CustomerAgreement.BuilderImpl> agreements) {
            this.agreements = AgreementListCopier.copyFromBuilder(agreements);
        }

        @Override
        public final Builder agreements(Collection<CustomerAgreement> agreements) {
            this.agreements = AgreementListCopier.copy(agreements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(CustomerAgreement ... agreements) {
            this.agreements(Arrays.asList(agreements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(Consumer<CustomerAgreement.Builder> ... agreements) {
            this.agreements(Stream.of(agreements).map(c -> (CustomerAgreement)((CustomerAgreement.Builder)CustomerAgreement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNniPartnerType() {
            return this.nniPartnerType;
        }

        public final void setNniPartnerType(String nniPartnerType) {
            this.nniPartnerType = nniPartnerType;
        }

        @Override
        public final Builder nniPartnerType(String nniPartnerType) {
            this.nniPartnerType = nniPartnerType;
            return this;
        }

        @Override
        public final Builder nniPartnerType(NniPartnerType nniPartnerType) {
            this.nniPartnerType(nniPartnerType == null ? null : nniPartnerType.toString());
            return this;
        }

        @Override
        public DescribeCustomerMetadataResponse build() {
            return new DescribeCustomerMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomerMetadataResponse> {
        public Builder agreements(Collection<CustomerAgreement> var1);

        public Builder agreements(CustomerAgreement ... var1);

        public Builder agreements(Consumer<CustomerAgreement.Builder> ... var1);

        public Builder nniPartnerType(String var1);

        public Builder nniPartnerType(NniPartnerType var1);
    }
}

