/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<String> LOCATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Location.getter(Location::locationCode)).setter(Location.setter(Builder::locationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationCode").build()}).build();
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Location.getter(Location::locationName)).setter(Location.setter(Builder::locationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Location.getter(Location::region)).setter(Location.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_CODE_FIELD, LOCATION_NAME_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String locationCode;
    private final String locationName;
    private final String region;

    private Location(BuilderImpl builder) {
        this.locationCode = builder.locationCode;
        this.locationName = builder.locationName;
        this.region = builder.region;
    }

    public String locationCode() {
        return this.locationCode;
    }

    public String locationName() {
        return this.locationName;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.locationCode(), other.locationCode()) && Objects.equals(this.locationName(), other.locationName()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"Location").add("LocationCode", (Object)this.locationCode()).add("LocationName", (Object)this.locationName()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationCode": {
                return Optional.ofNullable(clazz.cast(this.locationCode()));
            }
            case "locationName": {
                return Optional.ofNullable(clazz.cast(this.locationName()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationCode;
        private String locationName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.locationCode(model.locationCode);
            this.locationName(model.locationName);
            this.region(model.region);
        }

        public final String getLocationCode() {
            return this.locationCode;
        }

        @Override
        public final Builder locationCode(String locationCode) {
            this.locationCode = locationCode;
            return this;
        }

        public final void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        public final String getLocationName() {
            return this.locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder locationCode(String var1);

        public Builder locationName(String var1);

        public Builder region(String var1);
    }
}

