/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterType> {
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendor").getter(RouterType.getter(RouterType::vendor)).setter(RouterType.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(RouterType.getter(RouterType::platform)).setter(RouterType.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("software").getter(RouterType.getter(RouterType::software)).setter(RouterType.setter(Builder::software)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build()}).build();
    private static final SdkField<String> XSLT_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("xsltTemplateName").getter(RouterType.getter(RouterType::xsltTemplateName)).setter(RouterType.setter(Builder::xsltTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xsltTemplateName").build()}).build();
    private static final SdkField<String> XSLT_TEMPLATE_NAME_FOR_MAC_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("xsltTemplateNameForMacSec").getter(RouterType.getter(RouterType::xsltTemplateNameForMacSec)).setter(RouterType.setter(Builder::xsltTemplateNameForMacSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xsltTemplateNameForMacSec").build()}).build();
    private static final SdkField<String> ROUTER_TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routerTypeIdentifier").getter(RouterType.getter(RouterType::routerTypeIdentifier)).setter(RouterType.setter(Builder::routerTypeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerTypeIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_FIELD, PLATFORM_FIELD, SOFTWARE_FIELD, XSLT_TEMPLATE_NAME_FIELD, XSLT_TEMPLATE_NAME_FOR_MAC_SEC_FIELD, ROUTER_TYPE_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vendor;
    private final String platform;
    private final String software;
    private final String xsltTemplateName;
    private final String xsltTemplateNameForMacSec;
    private final String routerTypeIdentifier;

    private RouterType(BuilderImpl builder) {
        this.vendor = builder.vendor;
        this.platform = builder.platform;
        this.software = builder.software;
        this.xsltTemplateName = builder.xsltTemplateName;
        this.xsltTemplateNameForMacSec = builder.xsltTemplateNameForMacSec;
        this.routerTypeIdentifier = builder.routerTypeIdentifier;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final String platform() {
        return this.platform;
    }

    public final String software() {
        return this.software;
    }

    public final String xsltTemplateName() {
        return this.xsltTemplateName;
    }

    public final String xsltTemplateNameForMacSec() {
        return this.xsltTemplateNameForMacSec;
    }

    public final String routerTypeIdentifier() {
        return this.routerTypeIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.software());
        hashCode = 31 * hashCode + Objects.hashCode(this.xsltTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.xsltTemplateNameForMacSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerTypeIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterType)) {
            return false;
        }
        RouterType other = (RouterType)obj;
        return Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.software(), other.software()) && Objects.equals(this.xsltTemplateName(), other.xsltTemplateName()) && Objects.equals(this.xsltTemplateNameForMacSec(), other.xsltTemplateNameForMacSec()) && Objects.equals(this.routerTypeIdentifier(), other.routerTypeIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"RouterType").add("Vendor", (Object)this.vendor()).add("Platform", (Object)this.platform()).add("Software", (Object)this.software()).add("XsltTemplateName", (Object)this.xsltTemplateName()).add("XsltTemplateNameForMacSec", (Object)this.xsltTemplateNameForMacSec()).add("RouterTypeIdentifier", (Object)this.routerTypeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "software": {
                return Optional.ofNullable(clazz.cast(this.software()));
            }
            case "xsltTemplateName": {
                return Optional.ofNullable(clazz.cast(this.xsltTemplateName()));
            }
            case "xsltTemplateNameForMacSec": {
                return Optional.ofNullable(clazz.cast(this.xsltTemplateNameForMacSec()));
            }
            case "routerTypeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.routerTypeIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouterType, T> g) {
        return obj -> g.apply((RouterType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vendor;
        private String platform;
        private String software;
        private String xsltTemplateName;
        private String xsltTemplateNameForMacSec;
        private String routerTypeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterType model) {
            this.vendor(model.vendor);
            this.platform(model.platform);
            this.software(model.software);
            this.xsltTemplateName(model.xsltTemplateName);
            this.xsltTemplateNameForMacSec(model.xsltTemplateNameForMacSec);
            this.routerTypeIdentifier(model.routerTypeIdentifier);
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getSoftware() {
            return this.software;
        }

        public final void setSoftware(String software) {
            this.software = software;
        }

        @Override
        public final Builder software(String software) {
            this.software = software;
            return this;
        }

        public final String getXsltTemplateName() {
            return this.xsltTemplateName;
        }

        public final void setXsltTemplateName(String xsltTemplateName) {
            this.xsltTemplateName = xsltTemplateName;
        }

        @Override
        public final Builder xsltTemplateName(String xsltTemplateName) {
            this.xsltTemplateName = xsltTemplateName;
            return this;
        }

        public final String getXsltTemplateNameForMacSec() {
            return this.xsltTemplateNameForMacSec;
        }

        public final void setXsltTemplateNameForMacSec(String xsltTemplateNameForMacSec) {
            this.xsltTemplateNameForMacSec = xsltTemplateNameForMacSec;
        }

        @Override
        public final Builder xsltTemplateNameForMacSec(String xsltTemplateNameForMacSec) {
            this.xsltTemplateNameForMacSec = xsltTemplateNameForMacSec;
            return this;
        }

        public final String getRouterTypeIdentifier() {
            return this.routerTypeIdentifier;
        }

        public final void setRouterTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
        }

        @Override
        public final Builder routerTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
            return this;
        }

        public RouterType build() {
            return new RouterType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterType> {
        public Builder vendor(String var1);

        public Builder platform(String var1);

        public Builder software(String var1);

        public Builder xsltTemplateName(String var1);

        public Builder xsltTemplateNameForMacSec(String var1);

        public Builder routerTypeIdentifier(String var1);
    }
}

