/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.Location;
import software.amazon.awssdk.services.directconnect.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeLocationsResponse> {
    private static final SdkField<List<Location>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("locations").getter(DescribeLocationsResponse.getter(DescribeLocationsResponse::locations)).setter(DescribeLocationsResponse.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("locations", LOCATIONS_FIELD);
        }
    });
    private final List<Location> locations;

    private DescribeLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.locations = builder.locations;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<Location> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationsResponse)) {
            return false;
        }
        DescribeLocationsResponse other = (DescribeLocationsResponse)((Object)obj);
        return this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationsResponse").add("Locations", this.hasLocations() ? this.locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationsResponse, T> g) {
        return obj -> g.apply((DescribeLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Location> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationsResponse model) {
            super(model);
            this.locations(model.locations);
        }

        public final List<Location.Builder> getLocations() {
            List<Location.Builder> result = LocationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<Location.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<Location.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (Location)((Location.Builder)Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLocationsResponse build() {
            return new DescribeLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationsResponse> {
        public Builder locations(Collection<Location> var1);

        public Builder locations(Location ... var1);

        public Builder locations(Consumer<Location.Builder> ... var1);
    }
}

