/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AvailableMacSecPortSpeedsCopier;
import software.amazon.awssdk.services.directconnect.model.AvailablePortSpeedsCopier;
import software.amazon.awssdk.services.directconnect.model.ProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<String> LOCATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locationCode").getter(Location.getter(Location::locationCode)).setter(Location.setter(Builder::locationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationCode").build()}).build();
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locationName").getter(Location.getter(Location::locationName)).setter(Location.setter(Builder::locationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Location.getter(Location::region)).setter(Location.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<String>> AVAILABLE_PORT_SPEEDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availablePortSpeeds").getter(Location.getter(Location::availablePortSpeeds)).setter(Location.setter(Builder::availablePortSpeeds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availablePortSpeeds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABLE_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availableProviders").getter(Location.getter(Location::availableProviders)).setter(Location.setter(Builder::availableProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABLE_MAC_SEC_PORT_SPEEDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availableMacSecPortSpeeds").getter(Location.getter(Location::availableMacSecPortSpeeds)).setter(Location.setter(Builder::availableMacSecPortSpeeds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMacSecPortSpeeds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_CODE_FIELD, LOCATION_NAME_FIELD, REGION_FIELD, AVAILABLE_PORT_SPEEDS_FIELD, AVAILABLE_PROVIDERS_FIELD, AVAILABLE_MAC_SEC_PORT_SPEEDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String locationCode;
    private final String locationName;
    private final String region;
    private final List<String> availablePortSpeeds;
    private final List<String> availableProviders;
    private final List<String> availableMacSecPortSpeeds;

    private Location(BuilderImpl builder) {
        this.locationCode = builder.locationCode;
        this.locationName = builder.locationName;
        this.region = builder.region;
        this.availablePortSpeeds = builder.availablePortSpeeds;
        this.availableProviders = builder.availableProviders;
        this.availableMacSecPortSpeeds = builder.availableMacSecPortSpeeds;
    }

    public final String locationCode() {
        return this.locationCode;
    }

    public final String locationName() {
        return this.locationName;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasAvailablePortSpeeds() {
        return this.availablePortSpeeds != null && !(this.availablePortSpeeds instanceof SdkAutoConstructList);
    }

    public final List<String> availablePortSpeeds() {
        return this.availablePortSpeeds;
    }

    public final boolean hasAvailableProviders() {
        return this.availableProviders != null && !(this.availableProviders instanceof SdkAutoConstructList);
    }

    public final List<String> availableProviders() {
        return this.availableProviders;
    }

    public final boolean hasAvailableMacSecPortSpeeds() {
        return this.availableMacSecPortSpeeds != null && !(this.availableMacSecPortSpeeds instanceof SdkAutoConstructList);
    }

    public final List<String> availableMacSecPortSpeeds() {
        return this.availableMacSecPortSpeeds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailablePortSpeeds() ? this.availablePortSpeeds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableProviders() ? this.availableProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableMacSecPortSpeeds() ? this.availableMacSecPortSpeeds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.locationCode(), other.locationCode()) && Objects.equals(this.locationName(), other.locationName()) && Objects.equals(this.region(), other.region()) && this.hasAvailablePortSpeeds() == other.hasAvailablePortSpeeds() && Objects.equals(this.availablePortSpeeds(), other.availablePortSpeeds()) && this.hasAvailableProviders() == other.hasAvailableProviders() && Objects.equals(this.availableProviders(), other.availableProviders()) && this.hasAvailableMacSecPortSpeeds() == other.hasAvailableMacSecPortSpeeds() && Objects.equals(this.availableMacSecPortSpeeds(), other.availableMacSecPortSpeeds());
    }

    public final String toString() {
        return ToString.builder((String)"Location").add("LocationCode", (Object)this.locationCode()).add("LocationName", (Object)this.locationName()).add("Region", (Object)this.region()).add("AvailablePortSpeeds", this.hasAvailablePortSpeeds() ? this.availablePortSpeeds() : null).add("AvailableProviders", this.hasAvailableProviders() ? this.availableProviders() : null).add("AvailableMacSecPortSpeeds", this.hasAvailableMacSecPortSpeeds() ? this.availableMacSecPortSpeeds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationCode": {
                return Optional.ofNullable(clazz.cast(this.locationCode()));
            }
            case "locationName": {
                return Optional.ofNullable(clazz.cast(this.locationName()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "availablePortSpeeds": {
                return Optional.ofNullable(clazz.cast(this.availablePortSpeeds()));
            }
            case "availableProviders": {
                return Optional.ofNullable(clazz.cast(this.availableProviders()));
            }
            case "availableMacSecPortSpeeds": {
                return Optional.ofNullable(clazz.cast(this.availableMacSecPortSpeeds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationCode;
        private String locationName;
        private String region;
        private List<String> availablePortSpeeds = DefaultSdkAutoConstructList.getInstance();
        private List<String> availableProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> availableMacSecPortSpeeds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.locationCode(model.locationCode);
            this.locationName(model.locationName);
            this.region(model.region);
            this.availablePortSpeeds(model.availablePortSpeeds);
            this.availableProviders(model.availableProviders);
            this.availableMacSecPortSpeeds(model.availableMacSecPortSpeeds);
        }

        public final String getLocationCode() {
            return this.locationCode;
        }

        public final void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        @Override
        public final Builder locationCode(String locationCode) {
            this.locationCode = locationCode;
            return this;
        }

        public final String getLocationName() {
            return this.locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getAvailablePortSpeeds() {
            if (this.availablePortSpeeds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availablePortSpeeds;
        }

        public final void setAvailablePortSpeeds(Collection<String> availablePortSpeeds) {
            this.availablePortSpeeds = AvailablePortSpeedsCopier.copy(availablePortSpeeds);
        }

        @Override
        public final Builder availablePortSpeeds(Collection<String> availablePortSpeeds) {
            this.availablePortSpeeds = AvailablePortSpeedsCopier.copy(availablePortSpeeds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePortSpeeds(String ... availablePortSpeeds) {
            this.availablePortSpeeds(Arrays.asList(availablePortSpeeds));
            return this;
        }

        public final Collection<String> getAvailableProviders() {
            if (this.availableProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availableProviders;
        }

        public final void setAvailableProviders(Collection<String> availableProviders) {
            this.availableProviders = ProviderListCopier.copy(availableProviders);
        }

        @Override
        public final Builder availableProviders(Collection<String> availableProviders) {
            this.availableProviders = ProviderListCopier.copy(availableProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProviders(String ... availableProviders) {
            this.availableProviders(Arrays.asList(availableProviders));
            return this;
        }

        public final Collection<String> getAvailableMacSecPortSpeeds() {
            if (this.availableMacSecPortSpeeds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availableMacSecPortSpeeds;
        }

        public final void setAvailableMacSecPortSpeeds(Collection<String> availableMacSecPortSpeeds) {
            this.availableMacSecPortSpeeds = AvailableMacSecPortSpeedsCopier.copy(availableMacSecPortSpeeds);
        }

        @Override
        public final Builder availableMacSecPortSpeeds(Collection<String> availableMacSecPortSpeeds) {
            this.availableMacSecPortSpeeds = AvailableMacSecPortSpeedsCopier.copy(availableMacSecPortSpeeds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableMacSecPortSpeeds(String ... availableMacSecPortSpeeds) {
            this.availableMacSecPortSpeeds(Arrays.asList(availableMacSecPortSpeeds));
            return this;
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder locationCode(String var1);

        public Builder locationName(String var1);

        public Builder region(String var1);

        public Builder availablePortSpeeds(Collection<String> var1);

        public Builder availablePortSpeeds(String ... var1);

        public Builder availableProviders(Collection<String> var1);

        public Builder availableProviders(String ... var1);

        public Builder availableMacSecPortSpeeds(Collection<String> var1);

        public Builder availableMacSecPortSpeeds(String ... var1);
    }
}

