/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDirectConnectGatewayAssociationRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateDirectConnectGatewayAssociationRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(CreateDirectConnectGatewayAssociationRequest.getter(CreateDirectConnectGatewayAssociationRequest::directConnectGatewayId)).setter(CreateDirectConnectGatewayAssociationRequest.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(CreateDirectConnectGatewayAssociationRequest.getter(CreateDirectConnectGatewayAssociationRequest::gatewayId)).setter(CreateDirectConnectGatewayAssociationRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addAllowedPrefixesToDirectConnectGateway").getter(CreateDirectConnectGatewayAssociationRequest.getter(CreateDirectConnectGatewayAssociationRequest::addAllowedPrefixesToDirectConnectGateway)).setter(CreateDirectConnectGatewayAssociationRequest.setter(Builder::addAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayId").getter(CreateDirectConnectGatewayAssociationRequest.getter(CreateDirectConnectGatewayAssociationRequest::virtualGatewayId)).setter(CreateDirectConnectGatewayAssociationRequest.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, VIRTUAL_GATEWAY_ID_FIELD));
    private final String directConnectGatewayId;
    private final String gatewayId;
    private final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway;
    private final String virtualGatewayId;

    private CreateDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.gatewayId = builder.gatewayId;
        this.addAllowedPrefixesToDirectConnectGateway = builder.addAllowedPrefixesToDirectConnectGateway;
        this.virtualGatewayId = builder.virtualGatewayId;
    }

    public final String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final boolean hasAddAllowedPrefixesToDirectConnectGateway() {
        return this.addAllowedPrefixesToDirectConnectGateway != null && !(this.addAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    public final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway() {
        return this.addAllowedPrefixesToDirectConnectGateway;
    }

    public final String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddAllowedPrefixesToDirectConnectGateway() ? this.addAllowedPrefixesToDirectConnectGateway() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        CreateDirectConnectGatewayAssociationRequest other = (CreateDirectConnectGatewayAssociationRequest)((Object)obj);
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && this.hasAddAllowedPrefixesToDirectConnectGateway() == other.hasAddAllowedPrefixesToDirectConnectGateway() && Objects.equals(this.addAllowedPrefixesToDirectConnectGateway(), other.addAllowedPrefixesToDirectConnectGateway()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDirectConnectGatewayAssociationRequest").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("GatewayId", (Object)this.gatewayId()).add("AddAllowedPrefixesToDirectConnectGateway", this.hasAddAllowedPrefixesToDirectConnectGateway() ? this.addAllowedPrefixesToDirectConnectGateway() : null).add("VirtualGatewayId", (Object)this.virtualGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "addAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.addAllowedPrefixesToDirectConnectGateway()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectConnectGatewayAssociationRequest, T> g) {
        return obj -> g.apply((CreateDirectConnectGatewayAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String gatewayId;
        private List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();
        private String virtualGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectConnectGatewayAssociationRequest model) {
            super(model);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.gatewayId(model.gatewayId);
            this.addAllowedPrefixesToDirectConnectGateway(model.addAllowedPrefixesToDirectConnectGateway);
            this.virtualGatewayId(model.virtualGatewayId);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getAddAllowedPrefixesToDirectConnectGateway() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier.copyToBuilder(this.addAllowedPrefixesToDirectConnectGateway);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(addAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public final Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(addAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway(Arrays.asList(addAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway(Stream.of(addAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectConnectGatewayAssociationRequest build() {
            return new CreateDirectConnectGatewayAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDirectConnectGatewayAssociationRequest> {
        public Builder directConnectGatewayId(String var1);

        public Builder gatewayId(String var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder addAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder virtualGatewayId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

