/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, UpdateConnectionRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::connectionId)).setter(UpdateConnectionRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionName").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::connectionName)).setter(UpdateConnectionRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionMode").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::encryptionMode)).setter(UpdateConnectionRequest.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, CONNECTION_NAME_FIELD, ENCRYPTION_MODE_FIELD));
    private final String connectionId;
    private final String connectionName;
    private final String encryptionMode;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.connectionName = builder.connectionName;
        this.encryptionMode = builder.encryptionMode;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String encryptionMode() {
        return this.encryptionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.encryptionMode(), other.encryptionMode());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionRequest").add("ConnectionId", (Object)this.connectionId()).add("ConnectionName", (Object)this.connectionName()).add("EncryptionMode", (Object)this.encryptionMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "connectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "encryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String connectionName;
        private String encryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.connectionName(model.connectionName);
            this.encryptionMode(model.encryptionMode);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        @Transient
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        @Transient
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionRequest> {
        public Builder connectionId(String var1);

        public Builder connectionName(String var1);

        public Builder encryptionMode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

