/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AddressFamily {
    IPV4("ipv4"),
    IPV6("ipv6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AddressFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddressFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AddressFamily.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddressFamily> knownValues() {
        return Stream.of(AddressFamily.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

