/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateTransitVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(CreateTransitVirtualInterfaceRequest.getter(CreateTransitVirtualInterfaceRequest::connectionId)).setter(CreateTransitVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<NewTransitVirtualInterface> NEW_TRANSIT_VIRTUAL_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newTransitVirtualInterface").getter(CreateTransitVirtualInterfaceRequest.getter(CreateTransitVirtualInterfaceRequest::newTransitVirtualInterface)).setter(CreateTransitVirtualInterfaceRequest.setter(Builder::newTransitVirtualInterface)).constructor(NewTransitVirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTransitVirtualInterface").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, NEW_TRANSIT_VIRTUAL_INTERFACE_FIELD));
    private final String connectionId;
    private final NewTransitVirtualInterface newTransitVirtualInterface;

    private CreateTransitVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.newTransitVirtualInterface = builder.newTransitVirtualInterface;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final NewTransitVirtualInterface newTransitVirtualInterface() {
        return this.newTransitVirtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTransitVirtualInterface());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitVirtualInterfaceRequest)) {
            return false;
        }
        CreateTransitVirtualInterfaceRequest other = (CreateTransitVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.newTransitVirtualInterface(), other.newTransitVirtualInterface());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("NewTransitVirtualInterface", (Object)this.newTransitVirtualInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "newTransitVirtualInterface": {
                return Optional.ofNullable(clazz.cast(this.newTransitVirtualInterface()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreateTransitVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private NewTransitVirtualInterface newTransitVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.newTransitVirtualInterface(model.newTransitVirtualInterface);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final NewTransitVirtualInterface.Builder getNewTransitVirtualInterface() {
            return this.newTransitVirtualInterface != null ? this.newTransitVirtualInterface.toBuilder() : null;
        }

        @Override
        public final Builder newTransitVirtualInterface(NewTransitVirtualInterface newTransitVirtualInterface) {
            this.newTransitVirtualInterface = newTransitVirtualInterface;
            return this;
        }

        public final void setNewTransitVirtualInterface(NewTransitVirtualInterface.BuilderImpl newTransitVirtualInterface) {
            this.newTransitVirtualInterface = newTransitVirtualInterface != null ? newTransitVirtualInterface.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitVirtualInterfaceRequest build() {
            return new CreateTransitVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder newTransitVirtualInterface(NewTransitVirtualInterface var1);

        default public Builder newTransitVirtualInterface(Consumer<NewTransitVirtualInterface.Builder> newTransitVirtualInterface) {
            return this.newTransitVirtualInterface((NewTransitVirtualInterface)((NewTransitVirtualInterface.Builder)NewTransitVirtualInterface.builder().applyMutation(newTransitVirtualInterface)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

