/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.BGPPeerIdListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualInterfaceTestHistoryRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, ListVirtualInterfaceTestHistoryRequest> {
    private static final SdkField<String> TEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testId").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::testId)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::testId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::virtualInterfaceId)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bgpPeers").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::bgpPeers)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::bgpPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::status)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::maxResults)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVirtualInterfaceTestHistoryRequest.getter(ListVirtualInterfaceTestHistoryRequest::nextToken)).setter(ListVirtualInterfaceTestHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_ID_FIELD, VIRTUAL_INTERFACE_ID_FIELD, BGP_PEERS_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String testId;
    private final String virtualInterfaceId;
    private final List<String> bgpPeers;
    private final String status;
    private final Integer maxResults;
    private final String nextToken;

    private ListVirtualInterfaceTestHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.testId = builder.testId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String testId() {
        return this.testId;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final boolean hasBgpPeers() {
        return this.bgpPeers != null && !(this.bgpPeers instanceof SdkAutoConstructList);
    }

    public final List<String> bgpPeers() {
        return this.bgpPeers;
    }

    public final String status() {
        return this.status;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpPeers() ? this.bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualInterfaceTestHistoryRequest)) {
            return false;
        }
        ListVirtualInterfaceTestHistoryRequest other = (ListVirtualInterfaceTestHistoryRequest)((Object)obj);
        return Objects.equals(this.testId(), other.testId()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && this.hasBgpPeers() == other.hasBgpPeers() && Objects.equals(this.bgpPeers(), other.bgpPeers()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVirtualInterfaceTestHistoryRequest").add("TestId", (Object)this.testId()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("BgpPeers", this.hasBgpPeers() ? this.bgpPeers() : null).add("Status", (Object)this.status()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testId": {
                return Optional.ofNullable(clazz.cast(this.testId()));
            }
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "bgpPeers": {
                return Optional.ofNullable(clazz.cast(this.bgpPeers()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualInterfaceTestHistoryRequest, T> g) {
        return obj -> g.apply((ListVirtualInterfaceTestHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String testId;
        private String virtualInterfaceId;
        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualInterfaceTestHistoryRequest model) {
            super(model);
            this.testId(model.testId);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.bgpPeers(model.bgpPeers);
            this.status(model.status);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getTestId() {
            return this.testId;
        }

        @Override
        public final Builder testId(String testId) {
            this.testId = testId;
            return this;
        }

        public final void setTestId(String testId) {
            this.testId = testId;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final Collection<String> getBgpPeers() {
            if (this.bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bgpPeers;
        }

        @Override
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(String ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualInterfaceTestHistoryRequest build() {
            return new ListVirtualInterfaceTestHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualInterfaceTestHistoryRequest> {
        public Builder testId(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder bgpPeers(Collection<String> var1);

        public Builder bgpPeers(String ... var1);

        public Builder status(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

