/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.AssociatedGateway;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationState;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGatewayAssociation> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::directConnectGatewayId)).setter(DirectConnectGatewayAssociation.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayOwnerAccount").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::directConnectGatewayOwnerAccount)).setter(DirectConnectGatewayAssociation.setter(Builder::directConnectGatewayOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayOwnerAccount").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationState").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::associationStateAsString)).setter(DirectConnectGatewayAssociation.setter(Builder::associationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationState").build()}).build();
    private static final SdkField<String> STATE_CHANGE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateChangeError").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::stateChangeError)).setter(DirectConnectGatewayAssociation.setter(Builder::stateChangeError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeError").build()}).build();
    private static final SdkField<AssociatedGateway> ASSOCIATED_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("associatedGateway").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::associatedGateway)).setter(DirectConnectGatewayAssociation.setter(Builder::associatedGateway)).constructor(AssociatedGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGateway").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::associationId)).setter(DirectConnectGatewayAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedPrefixesToDirectConnectGateway").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::allowedPrefixesToDirectConnectGateway)).setter(DirectConnectGatewayAssociation.setter(Builder::allowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayId").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayId)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayRegion").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayRegion)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayRegion").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayOwnerAccount").getter(DirectConnectGatewayAssociation.getter(DirectConnectGatewayAssociation::virtualGatewayOwnerAccount)).setter(DirectConnectGatewayAssociation.setter(Builder::virtualGatewayOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayOwnerAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_OWNER_ACCOUNT_FIELD, ASSOCIATION_STATE_FIELD, STATE_CHANGE_ERROR_FIELD, ASSOCIATED_GATEWAY_FIELD, ASSOCIATION_ID_FIELD, ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, VIRTUAL_GATEWAY_ID_FIELD, VIRTUAL_GATEWAY_REGION_FIELD, VIRTUAL_GATEWAY_OWNER_ACCOUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directConnectGatewayId;
    private final String directConnectGatewayOwnerAccount;
    private final String associationState;
    private final String stateChangeError;
    private final AssociatedGateway associatedGateway;
    private final String associationId;
    private final List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway;
    private final String virtualGatewayId;
    private final String virtualGatewayRegion;
    private final String virtualGatewayOwnerAccount;

    private DirectConnectGatewayAssociation(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayOwnerAccount = builder.directConnectGatewayOwnerAccount;
        this.associationState = builder.associationState;
        this.stateChangeError = builder.stateChangeError;
        this.associatedGateway = builder.associatedGateway;
        this.associationId = builder.associationId;
        this.allowedPrefixesToDirectConnectGateway = builder.allowedPrefixesToDirectConnectGateway;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.virtualGatewayRegion = builder.virtualGatewayRegion;
        this.virtualGatewayOwnerAccount = builder.virtualGatewayOwnerAccount;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String directConnectGatewayOwnerAccount() {
        return this.directConnectGatewayOwnerAccount;
    }

    public DirectConnectGatewayAssociationState associationState() {
        return DirectConnectGatewayAssociationState.fromValue(this.associationState);
    }

    public String associationStateAsString() {
        return this.associationState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public AssociatedGateway associatedGateway() {
        return this.associatedGateway;
    }

    public String associationId() {
        return this.associationId;
    }

    public boolean hasAllowedPrefixesToDirectConnectGateway() {
        return this.allowedPrefixesToDirectConnectGateway != null && !(this.allowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    public List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway() {
        return this.allowedPrefixesToDirectConnectGateway;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public String virtualGatewayRegion() {
        return this.virtualGatewayRegion;
    }

    public String virtualGatewayOwnerAccount() {
        return this.virtualGatewayOwnerAccount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPrefixesToDirectConnectGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayOwnerAccount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAssociation)) {
            return false;
        }
        DirectConnectGatewayAssociation other = (DirectConnectGatewayAssociation)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.directConnectGatewayOwnerAccount(), other.directConnectGatewayOwnerAccount()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError()) && Objects.equals(this.associatedGateway(), other.associatedGateway()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.allowedPrefixesToDirectConnectGateway(), other.allowedPrefixesToDirectConnectGateway()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.virtualGatewayRegion(), other.virtualGatewayRegion()) && Objects.equals(this.virtualGatewayOwnerAccount(), other.virtualGatewayOwnerAccount());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGatewayAssociation").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("DirectConnectGatewayOwnerAccount", (Object)this.directConnectGatewayOwnerAccount()).add("AssociationState", (Object)this.associationStateAsString()).add("StateChangeError", (Object)this.stateChangeError()).add("AssociatedGateway", (Object)this.associatedGateway()).add("AssociationId", (Object)this.associationId()).add("AllowedPrefixesToDirectConnectGateway", this.allowedPrefixesToDirectConnectGateway()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("VirtualGatewayRegion", (Object)this.virtualGatewayRegion()).add("VirtualGatewayOwnerAccount", (Object)this.virtualGatewayOwnerAccount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "directConnectGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayOwnerAccount()));
            }
            case "associationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "stateChangeError": {
                return Optional.ofNullable(clazz.cast(this.stateChangeError()));
            }
            case "associatedGateway": {
                return Optional.ofNullable(clazz.cast(this.associatedGateway()));
            }
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "allowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.allowedPrefixesToDirectConnectGateway()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
            case "virtualGatewayRegion": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayRegion()));
            }
            case "virtualGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayOwnerAccount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAssociation, T> g) {
        return obj -> g.apply((DirectConnectGatewayAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String directConnectGatewayOwnerAccount;
        private String associationState;
        private String stateChangeError;
        private AssociatedGateway associatedGateway;
        private String associationId;
        private List<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();
        private String virtualGatewayId;
        private String virtualGatewayRegion;
        private String virtualGatewayOwnerAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAssociation model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.directConnectGatewayOwnerAccount(model.directConnectGatewayOwnerAccount);
            this.associationState(model.associationState);
            this.stateChangeError(model.stateChangeError);
            this.associatedGateway(model.associatedGateway);
            this.associationId(model.associationId);
            this.allowedPrefixesToDirectConnectGateway(model.allowedPrefixesToDirectConnectGateway);
            this.virtualGatewayId(model.virtualGatewayId);
            this.virtualGatewayRegion(model.virtualGatewayRegion);
            this.virtualGatewayOwnerAccount(model.virtualGatewayOwnerAccount);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayOwnerAccount() {
            return this.directConnectGatewayOwnerAccount;
        }

        @Override
        public final Builder directConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
            return this;
        }

        public final void setDirectConnectGatewayOwnerAccount(String directConnectGatewayOwnerAccount) {
            this.directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(DirectConnectGatewayAssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public final AssociatedGateway.Builder getAssociatedGateway() {
            return this.associatedGateway != null ? this.associatedGateway.toBuilder() : null;
        }

        @Override
        public final Builder associatedGateway(AssociatedGateway associatedGateway) {
            this.associatedGateway = associatedGateway;
            return this;
        }

        public final void setAssociatedGateway(AssociatedGateway.BuilderImpl associatedGateway) {
            this.associatedGateway = associatedGateway != null ? associatedGateway.build() : null;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Collection<RouteFilterPrefix.Builder> getAllowedPrefixesToDirectConnectGateway() {
            return this.allowedPrefixesToDirectConnectGateway != null ? (Collection)this.allowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder allowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(allowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway(Arrays.asList(allowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway(Stream.of(allowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> allowedPrefixesToDirectConnectGateway) {
            this.allowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(allowedPrefixesToDirectConnectGateway);
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final String getVirtualGatewayRegion() {
            return this.virtualGatewayRegion;
        }

        @Override
        public final Builder virtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
            return this;
        }

        public final void setVirtualGatewayRegion(String virtualGatewayRegion) {
            this.virtualGatewayRegion = virtualGatewayRegion;
        }

        public final String getVirtualGatewayOwnerAccount() {
            return this.virtualGatewayOwnerAccount;
        }

        @Override
        public final Builder virtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
            return this;
        }

        public final void setVirtualGatewayOwnerAccount(String virtualGatewayOwnerAccount) {
            this.virtualGatewayOwnerAccount = virtualGatewayOwnerAccount;
        }

        public DirectConnectGatewayAssociation build() {
            return new DirectConnectGatewayAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGatewayAssociation> {
        public Builder directConnectGatewayId(String var1);

        public Builder directConnectGatewayOwnerAccount(String var1);

        public Builder associationState(String var1);

        public Builder associationState(DirectConnectGatewayAssociationState var1);

        public Builder stateChangeError(String var1);

        public Builder associatedGateway(AssociatedGateway var1);

        default public Builder associatedGateway(Consumer<AssociatedGateway.Builder> associatedGateway) {
            return this.associatedGateway((AssociatedGateway)((AssociatedGateway.Builder)AssociatedGateway.builder().applyMutation(associatedGateway)).build());
        }

        public Builder associationId(String var1);

        public Builder allowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder allowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder allowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder virtualGatewayId(String var1);

        public Builder virtualGatewayRegion(String var1);

        public Builder virtualGatewayOwnerAccount(String var1);
    }
}

