/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptDirectConnectGatewayAssociationProposalRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(AcceptDirectConnectGatewayAssociationProposalRequest.getter(AcceptDirectConnectGatewayAssociationProposalRequest::directConnectGatewayId)).setter(AcceptDirectConnectGatewayAssociationProposalRequest.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("proposalId").getter(AcceptDirectConnectGatewayAssociationProposalRequest.getter(AcceptDirectConnectGatewayAssociationProposalRequest::proposalId)).setter(AcceptDirectConnectGatewayAssociationProposalRequest.setter(Builder::proposalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalId").build()}).build();
    private static final SdkField<String> ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedGatewayOwnerAccount").getter(AcceptDirectConnectGatewayAssociationProposalRequest.getter(AcceptDirectConnectGatewayAssociationProposalRequest::associatedGatewayOwnerAccount)).setter(AcceptDirectConnectGatewayAssociationProposalRequest.setter(Builder::associatedGatewayOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGatewayOwnerAccount").build()}).build();
    private static final SdkField<List<RouteFilterPrefix>> OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("overrideAllowedPrefixesToDirectConnectGateway").getter(AcceptDirectConnectGatewayAssociationProposalRequest.getter(AcceptDirectConnectGatewayAssociationProposalRequest::overrideAllowedPrefixesToDirectConnectGateway)).setter(AcceptDirectConnectGatewayAssociationProposalRequest.setter(Builder::overrideAllowedPrefixesToDirectConnectGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideAllowedPrefixesToDirectConnectGateway").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteFilterPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, PROPOSAL_ID_FIELD, ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD, OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));
    private final String directConnectGatewayId;
    private final String proposalId;
    private final String associatedGatewayOwnerAccount;
    private final List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway;

    private AcceptDirectConnectGatewayAssociationProposalRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.proposalId = builder.proposalId;
        this.associatedGatewayOwnerAccount = builder.associatedGatewayOwnerAccount;
        this.overrideAllowedPrefixesToDirectConnectGateway = builder.overrideAllowedPrefixesToDirectConnectGateway;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String proposalId() {
        return this.proposalId;
    }

    public String associatedGatewayOwnerAccount() {
        return this.associatedGatewayOwnerAccount;
    }

    public boolean hasOverrideAllowedPrefixesToDirectConnectGateway() {
        return this.overrideAllowedPrefixesToDirectConnectGateway != null && !(this.overrideAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    public List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway() {
        return this.overrideAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrideAllowedPrefixesToDirectConnectGateway() ? this.overrideAllowedPrefixesToDirectConnectGateway() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptDirectConnectGatewayAssociationProposalRequest)) {
            return false;
        }
        AcceptDirectConnectGatewayAssociationProposalRequest other = (AcceptDirectConnectGatewayAssociationProposalRequest)((Object)obj);
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.proposalId(), other.proposalId()) && Objects.equals(this.associatedGatewayOwnerAccount(), other.associatedGatewayOwnerAccount()) && this.hasOverrideAllowedPrefixesToDirectConnectGateway() == other.hasOverrideAllowedPrefixesToDirectConnectGateway() && Objects.equals(this.overrideAllowedPrefixesToDirectConnectGateway(), other.overrideAllowedPrefixesToDirectConnectGateway());
    }

    public String toString() {
        return ToString.builder((String)"AcceptDirectConnectGatewayAssociationProposalRequest").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("ProposalId", (Object)this.proposalId()).add("AssociatedGatewayOwnerAccount", (Object)this.associatedGatewayOwnerAccount()).add("OverrideAllowedPrefixesToDirectConnectGateway", this.hasOverrideAllowedPrefixesToDirectConnectGateway() ? this.overrideAllowedPrefixesToDirectConnectGateway() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "proposalId": {
                return Optional.ofNullable(clazz.cast(this.proposalId()));
            }
            case "associatedGatewayOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.associatedGatewayOwnerAccount()));
            }
            case "overrideAllowedPrefixesToDirectConnectGateway": {
                return Optional.ofNullable(clazz.cast(this.overrideAllowedPrefixesToDirectConnectGateway()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptDirectConnectGatewayAssociationProposalRequest, T> g) {
        return obj -> g.apply((AcceptDirectConnectGatewayAssociationProposalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String proposalId;
        private String associatedGatewayOwnerAccount;
        private List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptDirectConnectGatewayAssociationProposalRequest model) {
            super(model);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.proposalId(model.proposalId);
            this.associatedGatewayOwnerAccount(model.associatedGatewayOwnerAccount);
            this.overrideAllowedPrefixesToDirectConnectGateway(model.overrideAllowedPrefixesToDirectConnectGateway);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getProposalId() {
            return this.proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getAssociatedGatewayOwnerAccount() {
            return this.associatedGatewayOwnerAccount;
        }

        @Override
        public final Builder associatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
            return this;
        }

        public final void setAssociatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
        }

        public final Collection<RouteFilterPrefix.Builder> getOverrideAllowedPrefixesToDirectConnectGateway() {
            if (this.overrideAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList) {
                return null;
            }
            return this.overrideAllowedPrefixesToDirectConnectGateway != null ? (Collection)this.overrideAllowedPrefixesToDirectConnectGateway.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copy(overrideAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway(Arrays.asList(overrideAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway(Stream.of(overrideAllowedPrefixesToDirectConnectGateway).map(c -> (RouteFilterPrefix)((RouteFilterPrefix.Builder)RouteFilterPrefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOverrideAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix.BuilderImpl> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier.copyFromBuilder(overrideAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptDirectConnectGatewayAssociationProposalRequest build() {
            return new AcceptDirectConnectGatewayAssociationProposalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
        public Builder directConnectGatewayId(String var1);

        public Builder proposalId(String var1);

        public Builder associatedGatewayOwnerAccount(String var1);

        public Builder overrideAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> var1);

        public Builder overrideAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix ... var1);

        public Builder overrideAllowedPrefixesToDirectConnectGateway(Consumer<RouteFilterPrefix.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

