/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.ResourceTag;
import software.amazon.awssdk.services.directconnect.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTagsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTagsResponse.getter(DescribeTagsResponse::resourceTags)).setter(DescribeTagsResponse.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAGS_FIELD));
    private final List<ResourceTag> resourceTags;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTags = builder.resourceTags;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("ResourceTags", this.resourceTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.resourceTags(model.resourceTags);
        }

        public final Collection<ResourceTag.Builder> getResourceTags() {
            return this.resourceTags != null ? (Collection)this.resourceTags.stream().map(ResourceTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);
    }
}

